/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Preferences
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<String, Object> t = new Hashtable<String, Object>();

    public Preferences() {
    }

    public Preferences(Preferences p) {
        this.putAll(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences(String propertyFile) {
        Properties properties = new Properties();
        if (propertyFile != null) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(propertyFile);
                properties.load(inputStream);
                this.putAll(properties);
            }
            catch (FileNotFoundException e) {
                System.err.println("User specified preferences \"" + propertyFile + "\" not found!");
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Preferences(Properties properties) {
        this.putAll(properties);
    }

    public Object put(String key, Object value) {
        return this.t.put(key.toLowerCase(Locale.ENGLISH), value);
    }

    public Object get(String key) {
        return this.t.get(key.toLowerCase(Locale.ENGLISH));
    }

    public Object get(String key, Object defaultValue) {
        if (this.t.get(key.toLowerCase(Locale.ENGLISH)) != null) {
            return this.t.get(key.toLowerCase(Locale.ENGLISH));
        }
        return defaultValue;
    }

    public void putAll(Preferences p) {
        this.t.putAll(p.t);
    }

    public void putAll(Properties properties) {
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            this.t.put(key.toString().toLowerCase(Locale.ENGLISH), properties.get(key));
        }
    }

    public Object clone() {
        Preferences res = new Preferences();
        res.t = new Hashtable<String, Object>(this.t);
        return res;
    }

    public Object remove(String key) {
        return this.t.remove(key.toLowerCase(Locale.ENGLISH));
    }

    public boolean containsKey(String key) {
        return this.t.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public Set<String> keySet() {
        return this.t.keySet();
    }

    public boolean containsValue(Object value) {
        return this.t.containsValue(value);
    }

    public String toString() {
        return this.t.toString();
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Preferences)) {
            return false;
        }
        return this.t.equals(((Preferences)o).t);
    }
}

