/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class ResourceBrokerPollingExample {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\tUsage: bin/run_gat_app examples20.ResourceBrokerPollingExample <brokerURI> (where location is a valid JavaGAT URI)\n");
            System.exit(1);
        }
        new ResourceBrokerPollingExample().start(args[0]);
        GAT.end();
    }

    public void start(String brokerURI) {
        ResourceBroker broker = null;
        try {
            broker = GAT.createResourceBroker((URI)new URI(brokerURI));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create resource broker at location '" + brokerURI + "': " + (Object)((Object)e));
            return;
        }
        catch (URISyntaxException e) {
            System.err.println("Wrong uri '" + brokerURI + "': " + e);
            return;
        }
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/hostname");
        try {
            sd.setStdout(GAT.createFile((String)"hostname.txt"));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create the stdout file 'hostname.txt': " + (Object)((Object)e));
            return;
        }
        JobDescription jd = new JobDescription(sd);
        Job job = null;
        try {
            job = broker.submitJob((AbstractJobDescription)jd);
        }
        catch (GATInvocationException e) {
            System.err.println("Failed to submit the job: " + (Object)((Object)e));
            return;
        }
        while (job.getState() != Job.JobState.STOPPED) {
            System.out.println("job is in state: " + job.getState());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

