/*
 * Decompiled with CFR 0.152.
 */
package test;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.security.CertificateSecurityContext;
import org.gridlab.gat.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSubmitGlobus
implements MetricListener {
    public static final int NFILES = 10;
    public static final int NJOBS = 10;
    public static final int NBATCHES = 100;
    public static final int BACK = 3;
    private static Logger logger = LoggerFactory.getLogger(TestSubmitGlobus.class);
    private int finished;

    private static String getPassphrase() {
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{"grid-proxy-init\nPlease enter your passphrase.", pwd};
        JOptionPane.showMessageDialog(null, message, "Grid-Proxy-Init", 3);
        return new String(pwd.getPassword());
    }

    public static void main(String[] args) throws Exception {
        TestSubmitGlobus g = new TestSubmitGlobus();
        g.test(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(String host) throws Exception {
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/sleep");
        sd.setArguments(new String[]{"10"});
        final JobDescription jd = new JobDescription(sd);
        Preferences prefs = new Preferences();
        prefs.put("resourcebroker.adaptor.name", (Object)"wsgt4new");
        prefs.put("file.adaptor.name", (Object)"local,gridftp");
        CertificateSecurityContext ctxt = new CertificateSecurityContext(new URI(System.getProperty("user.home") + "/.globus/userkey.pem"), new URI(System.getProperty("user.home") + "/.globus/usercert.pem"), TestSubmitGlobus.getPassphrase());
        GATContext context = new GATContext();
        context.addPreferences(prefs);
        context.addSecurityContext((SecurityContext)ctxt);
        File[] files = new File[10];
        for (int i = 0; i < files.length; ++i) {
            files[i] = GAT.createFile((GATContext)context, (String)("file" + i));
            files[i].createNewFile();
        }
        for (File f : files) {
            sd.addPreStagedFile(f);
            sd.addPostStagedFile(f);
        }
        final ResourceBroker broker = GAT.createResourceBroker((GATContext)context, (URI)new URI(host));
        for (int j = 0; j < 100; ++j) {
            logger.info("Starting a batch of 10 jobs");
            for (int i = 0; i < 10; ++i) {
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            broker.submitJob((AbstractJobDescription)jd, (MetricListener)TestSubmitGlobus.this, "job.status");
                        }
                        catch (Throwable e) {
                            System.out.println("Submit failed");
                            e.printStackTrace();
                            TestSubmitGlobus testSubmitGlobus = TestSubmitGlobus.this;
                            synchronized (testSubmitGlobus) {
                                TestSubmitGlobus.this.finished++;
                                TestSubmitGlobus.this.notifyAll();
                            }
                        }
                    }
                };
                t.start();
            }
            TestSubmitGlobus testSubmitGlobus = this;
            synchronized (testSubmitGlobus) {
                while (this.finished < 10 * (j - 3)) {
                    logger.info("Waiting until at least " + 10 * (j - 3) + " jobs are finished");
                    try {
                        this.wait();
                    }
                    catch (Throwable throwable) {}
                }
                continue;
            }
        }
        TestSubmitGlobus testSubmitGlobus = this;
        synchronized (testSubmitGlobus) {
            while (this.finished != 1000) {
                try {
                    this.wait();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetricEvent(MetricEvent event) {
        if (event.getValue().equals(Job.JobState.STOPPED) || event.getValue().equals(Job.JobState.SUBMISSION_ERROR)) {
            TestSubmitGlobus testSubmitGlobus = this;
            synchronized (testSubmitGlobus) {
                ++this.finished;
                this.notifyAll();
            }
        }
    }
}

