/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.util.CoreManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudTypeManager {
    private final HashMap<String, CloudInstanceTypeDescription> types;
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Components.CloudManager");

    public CloudTypeManager() {
        logger.debug("Initializing CloudTypeManager");
        this.types = new HashMap();
    }

    public void addType(CloudInstanceTypeDescription type) {
        logger.debug("Add new type description " + type.getName());
        this.types.put(type.getName(), type);
    }

    public List<CloudInstanceTypeDescription> getCompatibleTypes(MethodResourceDescription requested) {
        LinkedList<CloudInstanceTypeDescription> compatiblesList = new LinkedList<CloudInstanceTypeDescription>();
        if (!this.types.isEmpty()) {
            for (CloudInstanceTypeDescription type : this.types.values()) {
                MethodResourceDescription resources = type.getResourceDescription();
                if (!resources.contains(requested)) continue;
                compatiblesList.add(type);
            }
        } else {
            CloudInstanceTypeDescription citd = new CloudInstanceTypeDescription("NO TYPE", requested);
            compatiblesList.add(citd);
        }
        return compatiblesList;
    }

    public Set<String> getAllTypeNames() {
        return this.types.keySet();
    }

    public Collection<CloudInstanceTypeDescription> getAllTypes() {
        return this.types.values();
    }

    public CloudInstanceTypeDescription getType(String name) {
        return this.types.get(name);
    }

    public int[][] getSimultaneousImpls(String type) {
        CloudInstanceTypeDescription t = this.types.get(type);
        if (t != null) {
            return t.getSlotsImpl();
        }
        return null;
    }

    public void newCoreElementsDetected(List<Integer> newCores) {
        int coreCount = CoreManager.getCoreCount();
        for (CloudInstanceTypeDescription type : this.types.values()) {
            int[][] slotsI = new int[coreCount][];
            int[] slotsC = Arrays.copyOf(type.getSlotsCore(), coreCount);
            for (int i = 0; i < type.getSlotsImplLength(); ++i) {
                int[] slotsImpl = type.getSpecificSlotsImpl(i);
                slotsI[i] = (int[])slotsImpl.clone();
            }
            for (int coreId : newCores) {
                List<Implementation> impls = CoreManager.getCoreImplementations(coreId);
                int implsSize = impls.size();
                slotsI[coreId] = new int[implsSize];
                for (int implId = 0; implId < implsSize; ++implId) {
                    Implementation impl = impls.get(implId);
                    if (impl.getTaskType() != Implementation.TaskType.METHOD) continue;
                    MethodResourceDescription rd = (MethodResourceDescription)impl.getRequirements();
                    Integer into = type.getResourceDescription().canHostSimultaneously(rd);
                    slotsC[coreId] = Math.max(slotsC[coreId], into);
                    slotsI[coreId][implId] = into;
                }
            }
            type.setSlotsCore(slotsC);
            type.setSlotsImpl(slotsI);
        }
    }

    public String getCurrentState(String prefix) {
        int coreCount = CoreManager.getCoreCount();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TYPES = [").append("\n");
        for (Map.Entry<String, CloudInstanceTypeDescription> type : this.types.entrySet()) {
            int i;
            sb.append(prefix).append("\t").append("TYPE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("KEY = ").append(type.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("CORES = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                sb.append(prefix).append("\t").append("\t").append("\t").append("CORE = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(type.getValue().getSpecificSlotsCore(i)).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("\t").append("IMPLEMENTATIONS = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                for (int j = 0; j < CoreManager.getNumberCoreImplementations(i); ++j) {
                    sb.append(prefix).append("\t").append("\t").append("\t").append("IMPLEMENTATION = [").append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(type.getValue().getSpecificSlotsImpl(i, j)).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
                }
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

