/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.worker.invokers;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.worker.invokers.BinaryRunner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.UUID;

public class GenericInvoker {
    private static final int NUM_BASE_MPI_ARGS = 6;
    private static final int NUM_BASE_DECAF_ARGS = 11;
    private static final int NUM_BASE_OMPSS_ARGS = 1;
    private static final int NUM_BASE_BINARY_ARGS = 1;
    private static final String OMP_NUM_THREADS = "OMP_NUM_THREADS";

    public static Object invokeMPIMethod(String mpiRunner, String mpiBinary, Object[] values, Stream[] streams, String[] prefixes, File taskSandboxWorkingDir, PrintStream defaultOutStream, PrintStream defaultErrStream) throws InvokeExecutionException {
        int i;
        System.out.println("");
        System.out.println("[MPI INVOKER] Begin MPI call to " + mpiBinary);
        System.out.println("[MPI INVOKER] On WorkingDir : " + taskSandboxWorkingDir.getAbsolutePath());
        String workers = System.getProperty("COMPSS_HOSTNAMES");
        String numNodes = System.getProperty("COMPSS_NUM_NODES");
        String computingUnits = System.getProperty("COMPSS_NUM_THREADS");
        String numProcs = String.valueOf(Integer.valueOf(numNodes) * Integer.valueOf(computingUnits));
        System.out.println("[MPI INVOKER] COMPSS HOSTNAMES: " + workers);
        System.out.println("[MPI INVOKER] COMPSS_NUM_NODES: " + numNodes);
        System.out.println("[MPI INVOKER] COMPSS_NUM_THREADS: " + computingUnits);
        String hostfile = GenericInvoker.writeHostfile(taskSandboxWorkingDir, workers);
        BinaryRunner.StreamSTD streamValues = new BinaryRunner.StreamSTD();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(values, streams, prefixes, streamValues);
        String[] cmd = new String[6 + binaryParams.size()];
        cmd[0] = mpiRunner;
        cmd[1] = "-hostfile";
        cmd[2] = hostfile;
        cmd[3] = "-n";
        cmd[4] = numProcs;
        cmd[5] = mpiBinary;
        for (i = 0; i < binaryParams.size(); ++i) {
            cmd[6 + i] = binaryParams.get(i);
        }
        System.setProperty(OMP_NUM_THREADS, computingUnits);
        System.out.print("[MPI INVOKER] MPI CMD: ");
        for (i = 0; i < cmd.length; ++i) {
            System.out.print(cmd[i] + " ");
        }
        System.out.println("");
        System.out.println("[MPI INVOKER] MPI STDIN: " + streamValues.getStdIn());
        System.out.println("[MPI INVOKER] MPI STDOUT: " + streamValues.getStdOut());
        System.out.println("[MPI INVOKER] MPI STDERR: " + streamValues.getStdErr());
        return BinaryRunner.executeCMD(cmd, streamValues, taskSandboxWorkingDir, defaultOutStream, defaultErrStream);
    }

    public static Object invokeDecafMethod(String dfRunner, String dfScript, String dfExecutor, String dfLib, String mpiRunner, Object[] values, Stream[] streams, String[] prefixes, File taskSandboxWorkingDir, PrintStream defaultOutStream, PrintStream defaultErrStream) throws InvokeExecutionException {
        System.out.println("");
        System.out.println("[DECAF INVOKER] Begin DECAF call to " + dfScript);
        System.out.println("[DECAF INVOKER] On WorkingDir : " + taskSandboxWorkingDir.getAbsolutePath());
        String workers = System.getProperty("COMPSS_HOSTNAMES");
        String numNodes = System.getProperty("COMPSS_NUM_NODES");
        String computingUnits = System.getProperty("COMPSS_NUM_THREADS");
        String numProcs = String.valueOf(Integer.valueOf(numNodes) * Integer.valueOf(computingUnits));
        System.out.println("[DECAF INVOKER] COMPSS HOSTNAMES: " + workers);
        System.out.println("[DECAF INVOKER] COMPSS_NUM_NODES: " + numNodes);
        System.out.println("[DECAF INVOKER] COMPSS_NUM_THREADS: " + computingUnits);
        String hostfile = GenericInvoker.writeHostfile(taskSandboxWorkingDir, workers);
        BinaryRunner.StreamSTD streamValues = new BinaryRunner.StreamSTD();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(values, streams, prefixes, streamValues);
        String args = new String();
        for (int i = 0; i < binaryParams.size(); ++i) {
            args = i == 0 ? args.concat(binaryParams.get(i)) : args.concat(" " + binaryParams.get(i));
        }
        String[] cmd = args.isEmpty() ? new String[9] : new String[11];
        cmd[0] = dfRunner;
        cmd[1] = dfScript;
        cmd[2] = dfExecutor;
        cmd[3] = dfLib;
        cmd[4] = mpiRunner;
        cmd[5] = "-n";
        cmd[6] = numProcs;
        cmd[7] = "--hostfile";
        cmd[8] = hostfile;
        if (!args.isEmpty()) {
            cmd[9] = "--args=\"";
            cmd[10] = args;
        }
        System.setProperty(OMP_NUM_THREADS, computingUnits);
        System.out.print("[DECAF INVOKER] Decaf CMD: ");
        for (int i = 0; i < cmd.length; ++i) {
            System.out.print(cmd[i] + " ");
        }
        System.out.println("");
        System.out.println("[DECAF INVOKER] Decaf STDIN: " + streamValues.getStdIn());
        System.out.println("[DECAF INVOKER] Decaf STDOUT: " + streamValues.getStdOut());
        System.out.println("[DECAF INVOKER] Decaf STDERR: " + streamValues.getStdErr());
        return BinaryRunner.executeCMD(cmd, streamValues, taskSandboxWorkingDir, defaultOutStream, defaultErrStream);
    }

    public static Object invokeOmpSsMethod(String ompssBinary, Object[] values, Stream[] streams, String[] prefixes, File taskSandboxWorkingDir, PrintStream defaultOutStream, PrintStream defaultErrStream) throws InvokeExecutionException {
        int i;
        System.out.println("");
        System.out.println("[OMPSS INVOKER] Begin ompss call to " + ompssBinary);
        System.out.println("[OMPSS INVOKER] On WorkingDir : " + taskSandboxWorkingDir.getAbsolutePath());
        String computingUnits = System.getProperty("COMPSS_NUM_THREADS");
        System.out.println("[OMPSS INVOKER] COMPSS_NUM_THREADS: " + computingUnits);
        BinaryRunner.StreamSTD streamValues = new BinaryRunner.StreamSTD();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(values, streams, prefixes, streamValues);
        String[] cmd = new String[1 + binaryParams.size()];
        cmd[0] = ompssBinary;
        for (i = 0; i < binaryParams.size(); ++i) {
            cmd[1 + i] = binaryParams.get(i);
        }
        System.setProperty(OMP_NUM_THREADS, computingUnits);
        System.out.print("[OMPSS INVOKER] BINARY CMD: ");
        for (i = 0; i < cmd.length; ++i) {
            System.out.print(cmd[i] + " ");
        }
        System.out.println("");
        System.out.println("[OMPSS INVOKER] OmpSs STDIN: " + streamValues.getStdIn());
        System.out.println("[OMPSS INVOKER] OmpSs STDOUT: " + streamValues.getStdOut());
        System.out.println("[OMPSS INVOKER] OmpSs STDERR: " + streamValues.getStdErr());
        return BinaryRunner.executeCMD(cmd, streamValues, taskSandboxWorkingDir, defaultOutStream, defaultErrStream);
    }

    public static Object invokeBinaryMethod(String binary, Object[] values, Stream[] streams, String[] prefixes, File taskSandboxWorkingDir, PrintStream defaultOutStream, PrintStream defaultErrStream) throws InvokeExecutionException {
        int i;
        System.out.println("");
        System.out.println("[BINARY INVOKER] Begin binary call to " + binary);
        System.out.println("[BINARY INVOKER] On WorkingDir : " + taskSandboxWorkingDir.getAbsolutePath());
        BinaryRunner.StreamSTD streamValues = new BinaryRunner.StreamSTD();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(values, streams, prefixes, streamValues);
        String[] cmd = new String[1 + binaryParams.size()];
        cmd[0] = binary;
        for (i = 0; i < binaryParams.size(); ++i) {
            cmd[1 + i] = binaryParams.get(i);
        }
        System.out.print("[BINARY INVOKER] BINARY CMD: ");
        for (i = 0; i < cmd.length; ++i) {
            System.out.print(cmd[i] + " ");
        }
        System.out.println("");
        System.out.println("[BINARY INVOKER] Binary STDIN: " + streamValues.getStdIn());
        System.out.println("[BINARY INVOKER] Binary STDOUT: " + streamValues.getStdOut());
        System.out.println("[BINARY INVOKER] Binary STDERR: " + streamValues.getStdErr());
        return BinaryRunner.executeCMD(cmd, streamValues, taskSandboxWorkingDir, defaultOutStream, defaultErrStream);
    }

    private static String writeHostfile(File taskSandboxWorkingDir, String workers) throws InvokeExecutionException {
        String uuid = UUID.randomUUID().toString();
        String filename = taskSandboxWorkingDir.getAbsolutePath() + File.separator + uuid + ".hostfile";
        String workersInLines = workers.replace(',', '\n');
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(workersInLines);
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("ERROR: Cannot write hostfile", ioe);
        }
        return filename;
    }
}

