/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

public class DescribeAddressesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<PublicIpInstanceIdPair>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private Set<PublicIpInstanceIdPair> pairs = Sets.newLinkedHashSet();
    private String ipAddress;
    private StringBuilder currentText = new StringBuilder();
    @Inject
    @Region
    Supplier<String> defaultRegion;
    private String instanceId;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("publicIp")) {
            this.ipAddress = this.currentOrNull();
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentOrNull();
        } else if (qName.equals("item")) {
            String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
            if (region == null) {
                region = this.defaultRegion.get();
            }
            this.pairs.add(new PublicIpInstanceIdPair(region, this.ipAddress, this.instanceId));
            this.ipAddress = null;
            this.instanceId = null;
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    @Override
    public Set<PublicIpInstanceIdPair> getResult() {
        return this.pairs;
    }
}

