/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Location;
import org.jclouds.joyent.cloudapi.v6_5.domain.Package;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.PackageInDatacenter;

public class PackageInDatacenterToHardware
implements Function<PackageInDatacenter, Hardware> {
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public PackageInDatacenterToHardware(Supplier<Map<String, Location>> locationIndex) {
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public Hardware apply(PackageInDatacenter pkgInDatacenter) {
        Location location = this.locationIndex.get().get(pkgInDatacenter.getDatacenter());
        Preconditions.checkState(location != null, "location %s not in locationIndex: %s", pkgInDatacenter.getDatacenter(), this.locationIndex.get());
        Package pkg = pkgInDatacenter.get();
        return new HardwareBuilder().id(pkgInDatacenter.slashEncode()).providerId(pkg.getName()).name(pkg.getName()).ram(pkg.getMemorySizeMb()).processor(new Processor(1.0, 1.0)).volume(new VolumeImpl(Float.valueOf(pkg.getDiskSizeGb()), true, true)).location(location).build();
    }
}

