/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import ibis.util.ConditionVariable;
import ibis.util.IllegalLockStateException;
import ibis.util.UtilProperties;
import java.io.PrintStream;

public final class Monitor {
    private static final String PROPERTY_PREFIX = "ibis.util.monitor.";
    private static final String asserts = "ibis.util.monitor.assert";
    private static final String stats = "ibis.util.monitor.stats";
    private static final String[] props = new String[]{"ibis.util.monitor.assert", "ibis.util.monitor.stats"};
    private static final UtilProperties myprops = new UtilProperties(System.getProperties(), "ibis.util.monitor.", props);
    static final boolean ASSERTS = myprops.getBooleanProperty("ibis.util.monitor.assert");
    static final boolean STATISTICS = myprops.getBooleanProperty("ibis.util.monitor.stats");
    final boolean PRIORITY;
    private boolean locked = false;
    private int waiters = 0;
    private int prio_waiters;
    private Thread owner;
    private static int lock_occupied;
    private static int unlock_waiting;
    private static int unlock_waiters;
    private static int unlock_bcast;

    public Monitor(boolean priority) {
        this.PRIORITY = priority;
    }

    public Monitor() {
        this(false);
    }

    public synchronized void lock() {
        this.lock(false);
    }

    public synchronized void lock(boolean priority) {
        if (!this.PRIORITY && priority) {
            throw new Error("Lock with priority=true for non-PRIORITY Monitor");
        }
        if (ASSERTS && this.owner == Thread.currentThread()) {
            throw new IllegalLockStateException("Already own monitor");
        }
        while (this.locked || this.PRIORITY && !priority && this.prio_waiters > 0) {
            if (STATISTICS) {
                ++lock_occupied;
            }
            if (this.PRIORITY && priority) {
                ++this.prio_waiters;
            }
            ++this.waiters;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.waiters;
            if (!this.PRIORITY) continue;
            if (priority) {
                --this.prio_waiters;
                continue;
            }
            if (this.prio_waiters <= 0) continue;
            this.notifyAll();
        }
        this.locked = true;
        if (ASSERTS) {
            this.owner = Thread.currentThread();
        }
    }

    public synchronized boolean tryLock() {
        if (this.locked || this.PRIORITY && this.prio_waiters > 0) {
            return false;
        }
        this.lock();
        return true;
    }

    public synchronized void unlock() {
        if (ASSERTS && this.owner != Thread.currentThread()) {
            Thread.dumpStack();
            throw new IllegalLockStateException("Don't own monitor");
        }
        this.locked = false;
        if (this.waiters > 0) {
            if (STATISTICS) {
                ++unlock_waiting;
                unlock_waiters += this.waiters;
            }
            if (!this.PRIORITY || this.prio_waiters == this.waiters) {
                if (STATISTICS) {
                    ++unlock_waiting;
                }
                this.notify();
            } else {
                if (STATISTICS) {
                    ++unlock_bcast;
                }
                this.notifyAll();
            }
        }
        if (ASSERTS) {
            this.owner = null;
        }
    }

    public ConditionVariable createCV() {
        return new ConditionVariable(this);
    }

    public ConditionVariable createCV(boolean interruptible) {
        return new ConditionVariable(this, interruptible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkImOwner() {
        if (ASSERTS) {
            Monitor monitor = this;
            synchronized (monitor) {
                if (this.owner != Thread.currentThread()) {
                    throw new IllegalLockStateException("Don't own monitor");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkImNotOwner() {
        if (ASSERTS) {
            Monitor monitor = this;
            synchronized (monitor) {
                if (this.owner == Thread.currentThread()) {
                    throw new IllegalLockStateException("Already own monitor");
                }
            }
        }
    }

    public static void report(PrintStream out) {
        if (STATISTICS) {
            out.println("Monitor: lock occupied " + lock_occupied + " unlock for waiter " + unlock_waiting + " prio-bcast " + unlock_bcast + " <waiters> " + (double)unlock_waiters / (double)unlock_waiting);
        }
    }

    public Thread getOwner() {
        return this.owner;
    }

    static {
        if (ASSERTS) {
            System.err.println("Turn on Monitor.ASSERTS");
        }
        if (STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread("Ibis Monitor ShutdownHook"){

                public void run() {
                    Monitor.report(System.err);
                    ConditionVariable.report(System.err);
                }
            });
        }
    }
}

