/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.CommandNotFoundException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.CommandRunner;
import org.gridlab.gat.security.ssh.SshSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshHelper {
    protected static Logger logger = LoggerFactory.getLogger(SshHelper.class);
    private final GATContext gatContext;
    private final URI location;
    private final String adaptorName;
    private boolean windows = false;
    private int ssh_port;
    private final String strictHostKeyChecking;
    private final Map<String, String> securityInfo;

    public SshHelper(GATContext gatContext, URI location, String adaptorName, String prefPortNo, String prefStrict) throws GATObjectCreationException {
        String s;
        String port;
        this.gatContext = gatContext;
        this.location = location;
        this.adaptorName = adaptorName;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            this.windows = true;
        }
        this.ssh_port = -1;
        if (location.getPort() != -1) {
            this.ssh_port = location.getPort();
        } else if (prefPortNo != null && (port = (String)gatContext.getPreferences().get(prefPortNo)) != null) {
            this.ssh_port = Integer.parseInt(port);
        }
        this.strictHostKeyChecking = prefStrict != null ? ("true".equals(s = (String)gatContext.getPreferences().get(prefStrict)) ? "yes" : "no") : null;
        this.securityInfo = SshSecurityUtils.getSecurityInfo(gatContext, location, adaptorName, this.ssh_port);
    }

    public String getUserName() {
        String user = this.location.getUserInfo();
        if (user != null) {
            return user;
        }
        if (!this.securityInfo.containsKey("default")) {
            return this.securityInfo.get("username");
        }
        return null;
    }

    public int getPort() {
        return this.ssh_port;
    }

    public String getPassword() {
        return this.securityInfo.get("password");
    }

    public boolean onWindows() {
        return this.windows;
    }

    public CommandRunner runSshCommand(String ... params) throws GATInvocationException {
        return this.runSshCommand(false, params);
    }

    public CommandRunner runSshCommand(boolean stoppable, String ... params) throws GATInvocationException {
        return this.runSshCommand(this.getSshCommand(stoppable), params);
    }

    public CommandRunner runSshCommand(List<String> command, String ... params) throws GATInvocationException {
        for (String p : params) {
            command.add(SshHelper.protectAgainstShellMetas(p));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("running command = " + command);
        }
        CommandRunner runner = new CommandRunner(command);
        int exitVal = runner.getExitCode();
        if (logger.isDebugEnabled()) {
            logger.debug("exitCode=" + exitVal);
        }
        if (exitVal == 255) {
            if (logger.isInfoEnabled()) {
                logger.info("command failed, error=" + runner.getStderr());
            }
            throw new GATInvocationException("invocation error");
        }
        return runner;
    }

    public Process startSshCommand(List<String> command, String[] params) throws CommandNotFoundException {
        if (params != null) {
            for (String arg : params) {
                command.add(SshHelper.protectAgainstShellMetas(arg));
            }
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        if (logger.isInfoEnabled()) {
            logger.info("running command: " + command);
        }
        Process p = null;
        try {
            p = builder.start();
        }
        catch (IOException e) {
            throw new CommandNotFoundException("builder.start() fails", e);
        }
        return p;
    }

    public static String protectAgainstShellMetas(String s) {
        char[] chars = s.toCharArray();
        StringBuffer b = new StringBuffer();
        b.append('\'');
        for (char c : chars) {
            if (c == '\'') {
                b.append('\'');
                b.append('\\');
                b.append('\'');
            }
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }

    public ArrayList<String> getSshCommand(boolean stoppable) {
        String username;
        ArrayList<String> command = new ArrayList<String>();
        if (this.windows) {
            int privateKeySlot;
            block15: {
                command.add("sexec");
                if (this.getUserName() != null) {
                    command.add(this.getUserName() + "@" + this.location.getAuthority());
                } else {
                    command.add(this.location.getAuthority());
                }
                command.add("-unat=yes");
                if (this.ssh_port != -1) {
                    command.add("-P");
                    command.add("" + this.ssh_port);
                }
                privateKeySlot = -1;
                try {
                    String v = this.securityInfo.get("privatekeyslot");
                    if (v != null) {
                        privateKeySlot = Integer.parseInt(v);
                    }
                }
                catch (NumberFormatException e) {
                    if (!logger.isDebugEnabled()) break block15;
                    logger.debug("unable to parse private key slot: " + e);
                }
            }
            if (this.getPassword() == null) {
                int slot = privateKeySlot;
                if (slot == -1) {
                    slot = 0;
                }
                command.add(" -pk=" + slot);
            } else {
                command.add(" -pw=" + this.getPassword());
            }
            return command;
        }
        command.add("ssh");
        if (this.ssh_port != -1) {
            command.add("-p");
            command.add("" + this.ssh_port);
        }
        command.add("-o");
        command.add("BatchMode=yes");
        if (stoppable) {
            command.add("-t");
            command.add("-t");
        }
        if (this.strictHostKeyChecking != null) {
            command.add("-o");
            command.add("StrictHostKeyChecking=" + this.strictHostKeyChecking);
        }
        if ((username = this.getUserName()) != null) {
            command.add(username + "@" + this.location.resolveHost());
        } else {
            command.add(this.location.resolveHost());
        }
        return command;
    }

    public ArrayList<String> getScpCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("scp");
        if (this.windows) {
            command.add("-unat=yes");
            if (this.ssh_port != -1) {
                command.add("-P");
                command.add("" + this.ssh_port);
            }
            if (!this.securityInfo.containsKey("password")) {
                int slot = 0;
                try {
                    slot = Integer.parseInt(this.securityInfo.get("privatekeyslot"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                command.add("-pk=" + slot);
            } else {
                command.add(" -pw=" + this.securityInfo.get("password"));
            }
        } else {
            if (this.ssh_port != -1) {
                command.add("-P");
                command.add("" + this.ssh_port);
            }
            command.add("-o");
            command.add("BatchMode=yes");
            if (this.strictHostKeyChecking != null) {
                command.add("-o");
                command.add("StrictHostKeyChecking=" + this.strictHostKeyChecking);
            }
            command.add("-p");
        }
        return command;
    }
}

