/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors;

import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.ExternalExecutor;
import es.bsc.compss.types.resources.components.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CExecutionCommandGenerator {
    private static final String C_LIB_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "c" + File.separator + "lib";
    private static final String WORKER_C_RELATIVE_PATH = File.separator + "worker" + File.separator + "worker_c";
    private static final String LIBRARY_PATH_ENV = "LD_LIBRARY_PATH";
    private static final String QUOTES = "\"";
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    protected static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();

    public static ArrayList<String> getTaskExecutionCommand(NIOWorker nw, NIOTask nt, String sandBox, int[] assignedCoreUnits, int[] assignedGPUs, int[] assignedFPGAs) {
        ArrayList<String> lArgs = new ArrayList<String>();
        StringBuilder reqs = new StringBuilder();
        int numCUs = nt.getResourceDescription().getTotalCPUComputingUnits();
        reqs.append("NX_ARGS='--smp-cpus=").append(numCUs);
        String compss_nx_args = System.getenv("COMPSS_NX_ARGS");
        if (compss_nx_args != null) {
            reqs.append(" " + compss_nx_args);
        }
        if (WORKER_DEBUG) {
            reqs.append("#--summary#--verbose-copies#--verbose");
        }
        StringBuilder cuda_visible = new StringBuilder();
        StringBuilder opencl_visible = new StringBuilder();
        cuda_visible.append("CUDA_VISIBLE_DEVICES=").append(QUOTES);
        opencl_visible.append("GPU_DEVICE_ORDINAL=").append(QUOTES);
        if (assignedGPUs.length > 0) {
            reqs.append("#--gpu-warmup=no");
            for (int i = 0; i < assignedGPUs.length - 1; ++i) {
                cuda_visible.append(assignedGPUs[i]).append(",");
                opencl_visible.append(assignedGPUs[i]).append(",");
            }
            cuda_visible.append(assignedGPUs[assignedGPUs.length - 1]);
            opencl_visible.append(assignedGPUs[assignedGPUs.length - 1]);
            for (int j = 0; j < nt.getResourceDescription().getProcessors().size(); ++j) {
                Processor p = nt.getResourceDescription().getProcessors().get(j);
                if (!p.getType().equals("GPU") || !((double)p.getInternalMemory() > 1.0E-5)) continue;
                float bytes = p.getInternalMemory() * 1048576.0f;
                int b_int = Math.round(bytes);
                reqs.append("#--gpu-max-memory=").append(b_int);
            }
        } else if (assignedFPGAs.length > 0) {
            reqs.append("#--disable-cuda=yes");
        } else {
            reqs.append("#--disable-cuda=yes");
            reqs.append("#--disable-opencl=yes");
            reqs.append("#--disable-fpga=yes");
        }
        cuda_visible.append(QUOTES);
        opencl_visible.append(QUOTES);
        reqs.append("'");
        StringBuilder taskset = new StringBuilder();
        if (assignedCoreUnits != null && assignedCoreUnits.length > 0) {
            taskset.append("taskset -c ");
            for (int i = 0; i < numCUs - 1; ++i) {
                taskset.append(assignedCoreUnits[i]).append(",");
            }
            taskset.append(assignedCoreUnits[numCUs - 1]).append(" ");
        }
        lArgs.add(cuda_visible.toString() + ";" + opencl_visible.toString() + ";" + reqs.toString() + " " + taskset.toString() + nw.getAppDir() + WORKER_C_RELATIVE_PATH);
        return lArgs;
    }

    public static Map<String, String> getEnvironment(NIOWorker nw) {
        HashMap<String, String> env = new HashMap<String, String>();
        String ldLibraryPath = System.getenv(LIBRARY_PATH_ENV);
        ldLibraryPath = ldLibraryPath == null ? nw.getLibPath() : ldLibraryPath.concat(":" + nw.getLibPath());
        ldLibraryPath = ldLibraryPath.concat(":" + nw.getInstallDir() + C_LIB_RELATIVE_PATH);
        ldLibraryPath = ldLibraryPath.concat(":" + nw.getInstallDir() + ExternalExecutor.BINDINGS_RELATIVE_PATH);
        env.put(LIBRARY_PATH_ENV, ldLibraryPath);
        return env;
    }
}

