/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors.util;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.util.Invoker;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.worker.invokers.GenericInvoker;
import java.io.File;

public class OmpSsInvoker
extends Invoker {
    private final String ompssBinary;

    public OmpSsInvoker(NIOWorker nw, NIOTask nt, File taskSandboxWorkingDir, int[] assignedCoreUnits) throws JobExecutionException {
        super(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
        OmpSsImplementation ompssImpl = null;
        try {
            ompssImpl = (OmpSsImplementation)this.impl;
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.methodType), e);
        }
        this.ompssBinary = ompssImpl.getBinary();
    }

    @Override
    public Object invokeMethod() throws JobExecutionException {
        LOGGER.info("Invoked " + this.ompssBinary + " in " + this.nw.getHostName());
        try {
            return GenericInvoker.invokeOmpSsMethod(this.ompssBinary, this.values, this.streams, this.prefixes, this.taskSandboxWorkingDir, this.nw.getThreadOutStream(), this.nw.getThreadErrStream());
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException(iee);
        }
    }
}

