/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.api.COMPSsRuntime;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ErrorManager {
    public static final String NEWLINE = "\r\n";
    private static final String REGEX_NEWLINE = "\r\n|\n|\r";
    private static final String PREFIX_ERRMGR = "[ERRMGR]  -  ";
    private static final String PREFIX_WARNING = "[ERRMGR]  -  WARNING: ";
    private static final String PREFIX_ERROR = "[ERRMGR]  -  ERROR:   ";
    private static final String PREFIX_FATAL = "[ERRMGR]  -  FATAL:   ";
    private static final String SUFFIX_SHUTTING_DOWN = "[ERRMGR]  -  Shutting down COMPSs...";
    private static final Integer REQUEST_ERROR = 1;
    private static final Integer REQUEST_FATAL = 2;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.ErrorManager");
    private static COMPSsRuntime compssRuntime = null;
    private static Integer errorRequest = -1;
    private static boolean stopping = false;
    private static Runnable errorRunnable = new Runnable(){

        @Override
        public void run() {
            if (errorRequest == REQUEST_ERROR || errorRequest == REQUEST_FATAL) {
                if (compssRuntime != null) {
                    LOGGER.error("[ERRMGR]  -  Error detected. Shutting down COMPSs");
                    compssRuntime.stopIT(true);
                }
                System.exit(1);
            }
        }
    };

    public static void init(COMPSsRuntime compssRuntime) {
        ErrorManager.compssRuntime = compssRuntime;
    }

    public static void warn(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_WARNING, msg, e, System.err);
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.warn(line);
            }
        }
    }

    public static void warn(Exception e) {
        ErrorManager.warn("", e);
    }

    public static void warn(String msg) {
        ErrorManager.warn(msg, null);
    }

    public static synchronized void error(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_ERROR, msg, e, System.err);
            ErrorManager.prettyPrint("", SUFFIX_SHUTTING_DOWN, null, System.err);
            stopping = true;
            errorRequest = REQUEST_ERROR;
            new Thread(errorRunnable, "ErrorManager Error Thread").start();
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.error(line);
            }
        }
    }

    public static void error(Exception e) {
        ErrorManager.error("", e);
    }

    public static void error(String msg) {
        ErrorManager.error(msg, null);
    }

    public static synchronized void fatal(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_FATAL, msg, e, System.err);
            ErrorManager.prettyPrint("", SUFFIX_SHUTTING_DOWN, null, System.err);
            stopping = true;
            errorRequest = REQUEST_FATAL;
            new Thread(errorRunnable, "ErrorManager Fatal Thread").start();
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.fatal(line);
            }
        }
    }

    public static void fatal(Exception e) {
        ErrorManager.fatal("", e);
    }

    public static void fatal(String msg) {
        ErrorManager.fatal(msg, null);
    }

    private static void prettyPrint(String prefix, String _msg, Exception e, PrintStream ps) {
        String msg = _msg;
        if (e != null) {
            msg = msg + NEWLINE;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            msg = msg + "Stack trace:\r\n" + sw.toString();
        }
        String[] lines = msg.split(REGEX_NEWLINE);
        for (int i = 0; i < lines.length; ++i) {
            String l = lines[i];
            l = i == 0 ? prefix + l : ErrorManager.indent(l, prefix.length());
            ps.println(l);
        }
    }

    private static String indent(String str, int indentation) {
        for (int j = 0; j < indentation; ++j) {
            str = " " + str;
        }
        return str;
    }

    private ErrorManager() {
        throw new UnsupportedOperationException();
    }
}

