/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.localQ;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.engine.util.CommandRunner;
import org.gridlab.gat.engine.util.InputForwarder;
import org.gridlab.gat.engine.util.OutputForwarder;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.localQ.LocalQResourceBrokerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQJob
extends JobCpi
implements Runnable,
Comparable<LocalQJob> {
    private static final Logger logger = LoggerFactory.getLogger(LocalQJob.class);
    private final MetricDefinition statusMetricDefinition;
    private final Metric statusMetric;
    private final int priority;
    private int exitVal = 0;
    private long runTime;
    private boolean stopped = false;
    private Process p = null;
    private String processID = "";

    LocalQJob(GATContext gatContext, LocalQResourceBrokerAdaptor broker, JobDescription description, Sandbox sandbox) {
        super(gatContext, description, sandbox);
        this.priority = description.getSoftwareDescription().getIntAttribute("localq.job.priority", 0);
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
        this.setSubmissionTime();
    }

    public synchronized Map<String, Object> getInfo() throws GATInvocationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.getState();
        m.put("state", this.state.toString());
        if (this.state != Job.JobState.RUNNING) {
            m.put("hostname", null);
        } else {
            m.put("hostname", GATEngine.getLocalHostName());
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN) {
            m.put("submissiontime", null);
        } else {
            m.put("adaptor.job.id", this.processID);
            m.put("submissiontime", this.submissiontime);
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN || this.state == Job.JobState.SCHEDULED) {
            m.put("starttime", null);
        } else {
            m.put("starttime", this.starttime);
        }
        if (this.state != Job.JobState.STOPPED) {
            m.put("stoptime", null);
        } else {
            m.put("stoptime", this.stoptime);
        }
        m.put("poststage.exception", (Object)this.postStageException);
        m.put("resourcebroker", "Local");
        m.put("exitvalue", "" + this.exitVal);
        if (this.deleteException != null) {
            m.put("delete.exception", (Object)this.deleteException);
        }
        if (this.wipeException != null) {
            m.put("wipe.exception", (Object)this.wipeException);
        }
        return m;
    }

    public synchronized int getExitStatus() throws GATInvocationException {
        if (this.state != Job.JobState.STOPPED) {
            throw new GATInvocationException("not in RUNNING state");
        }
        return this.exitVal;
    }

    public synchronized void stop() throws GATInvocationException {
        if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
            return;
        }
        this.p.destroy();
        if (!this.gatContext.getPreferences().containsKey("job.stop.poststage") || !this.gatContext.getPreferences().get("job.stop.poststage").equals("false")) {
            this.setState(Job.JobState.POST_STAGING);
            this.sandbox.retrieveAndCleanup((JobCpi)this);
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Job.JobState state) {
        MetricEvent metricEvent = null;
        LocalQJob localQJob = this;
        synchronized (localQJob) {
            this.state = state;
            metricEvent = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
            if (logger.isDebugEnabled()) {
                logger.debug("default job callback: firing event: " + metricEvent);
            }
        }
        this.fireMetric(metricEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream out;
        Process p;
        logger.debug("running job with priority: " + this.priority);
        SoftwareDescription description = this.jobDescription.getSoftwareDescription();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.jobDescription.getSoftwareDescription().getEnvironment() != null) {
            processBuilder.environment().clear();
            for (Map.Entry entry : this.jobDescription.getSoftwareDescription().getEnvironment().entrySet()) {
                processBuilder.environment().put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String exe = this.sandbox.getResolvedExecutable() != null ? this.sandbox.getResolvedExecutable().getPath() : description.getExecutable();
        try {
            new CommandRunner(new String[]{"chmod", "+x", exe});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        processBuilder.command().add(exe);
        if (description.getArguments() != null) {
            for (String argument : description.getArguments()) {
                processBuilder.command().add(argument);
            }
        }
        File file = new File(System.getProperty("user.home") + File.separator + this.sandbox.getSandbox());
        processBuilder.directory(file);
        if (logger.isDebugEnabled()) {
            logger.debug("running command: ");
            for (String element : processBuilder.command()) {
                logger.debug("    " + element);
            }
        }
        LocalQJob element = this;
        synchronized (element) {
            if (this.stopped) {
                return;
            }
            try {
                this.p = p = processBuilder.start();
                this.setStartTime();
            }
            catch (IOException e) {
                logger.error("Got exception, setting state to SUBMISSION_ERROR", (Throwable)e);
                this.setState(Job.JobState.SUBMISSION_ERROR);
                return;
            }
        }
        Field f = null;
        try {
            f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            this.processID = f.get(p).toString();
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        org.gridlab.gat.io.File stdin = this.sandbox.getResolvedStdin();
        org.gridlab.gat.io.File stdout = this.sandbox.getResolvedStdout();
        org.gridlab.gat.io.File stderr = this.sandbox.getResolvedStderr();
        if (stdin == null) {
            try {
                p.getOutputStream().close();
            }
            catch (Throwable throwable) {}
        } else {
            try {
                FileInputStream fin = new FileInputStream(stdin.getAbsolutePath());
                out = p.getOutputStream();
                new InputForwarder(out, (InputStream)fin);
            }
            catch (Exception e) {
                logger.error("Got exception, setting state to SUBMISSION_ERROR", (Throwable)e);
                this.setState(Job.JobState.SUBMISSION_ERROR);
                return;
            }
        }
        OutputForwarder outForwarder = null;
        if (stdout == null) {
            new OutputForwarder(p.getInputStream(), false);
        } else {
            try {
                out = new FileOutputStream(stdout.getAbsolutePath(), true);
                outForwarder = new OutputForwarder(p.getInputStream(), out);
            }
            catch (Exception e) {
                logger.error("Got exception, setting state to SUBMISSION_ERROR", (Throwable)e);
                this.setState(Job.JobState.SUBMISSION_ERROR);
                return;
            }
        }
        OutputForwarder errForwarder = null;
        if (stderr == null) {
            new OutputForwarder(p.getErrorStream(), false);
        } else {
            try {
                FileOutputStream out2 = new FileOutputStream(stderr.getAbsolutePath());
                errForwarder = new OutputForwarder(p.getErrorStream(), (OutputStream)out2);
            }
            catch (Exception e) {
                this.setState(Job.JobState.SUBMISSION_ERROR);
                return;
            }
        }
        this.setState(Job.JobState.RUNNING);
        int exitValue = 0;
        try {
            exitValue = p.waitFor();
            this.setStopTime();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LocalQJob localQJob = this;
        synchronized (localQJob) {
            this.exitVal = exitValue;
            this.runTime = System.currentTimeMillis() - this.runTime;
        }
        if (outForwarder != null) {
            outForwarder.waitUntilFinished();
        }
        if (errForwarder != null) {
            errForwarder.waitUntilFinished();
        }
        this.setState(Job.JobState.POST_STAGING);
        this.sandbox.retrieveAndCleanup((JobCpi)this);
        this.finished();
        this.setState(Job.JobState.STOPPED);
        if (logger.isDebugEnabled()) {
            logger.debug("TIMING: job " + this.jobID + ":" + " preStage: " + this.sandbox.getPreStageTime() + " run: " + (this.stoptime - this.starttime) + " postStage: " + this.sandbox.getPostStageTime() + " wipe: " + this.sandbox.getWipeTime() + " delete: " + this.sandbox.getDeleteTime() + " total: " + (System.currentTimeMillis() - this.starttime));
        }
    }

    @Override
    public int compareTo(LocalQJob other) {
        if (this.priority != other.priority) {
            return other.priority - this.priority;
        }
        return this.jobID - other.jobID;
    }
}

