/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.javax.annotation.Nullable;

public class ISOExtraction {
    private final String id;
    private final String accountId;
    private final Date created;
    private final String extractId;
    private final ExtractMode extractMode;
    private final String name;
    private final String state;
    private final String status;
    private final String storageType;
    private final int uploadPercentage;
    private final String url;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromISOExtraction(this);
    }

    @ConstructorProperties(value={"id", "accountid", "created", "extractId", "extractMode", "name", "state", "status", "storagetype", "uploadpercentage", "url", "zoneid", "zonename"})
    protected ISOExtraction(String id, @Nullable String accountId, @Nullable Date created, @Nullable String extractId, @Nullable ExtractMode extractMode, @Nullable String name, @Nullable String state, @Nullable String status, @Nullable String storageType, int uploadPercentage, @Nullable String url, @Nullable String zoneId, @Nullable String zoneName) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.accountId = accountId;
        this.created = created;
        this.extractId = extractId;
        this.extractMode = extractMode;
        this.name = name;
        this.state = state;
        this.status = status;
        this.storageType = storageType;
        this.uploadPercentage = uploadPercentage;
        this.url = url;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getExtractId() {
        return this.extractId;
    }

    @Nullable
    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Nullable
    public String getStorageType() {
        return this.storageType;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ISOExtraction that = (ISOExtraction)ISOExtraction.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.accountId, that.accountId) && Objects.equal(this.created, that.created) && Objects.equal(this.extractId, that.extractId) && Objects.equal((Object)this.extractMode, (Object)that.extractMode) && Objects.equal(this.name, that.name) && Objects.equal(this.state, that.state) && Objects.equal(this.status, that.status) && Objects.equal(this.storageType, that.storageType) && Objects.equal(this.uploadPercentage, that.uploadPercentage) && Objects.equal(this.url, that.url) && Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.zoneName, that.zoneName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("accountId", this.accountId).add("created", this.created).add("extractId", this.extractId).add("extractMode", (Object)this.extractMode).add("name", this.name).add("state", this.state).add("status", this.status).add("storageType", this.storageType).add("uploadPercentage", this.uploadPercentage).add("url", this.url).add("zoneId", this.zoneId).add("zoneName", this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String accountId;
        protected Date created;
        protected String extractId;
        protected ExtractMode extractMode;
        protected String name;
        protected String state;
        protected String status;
        protected String storageType;
        protected int uploadPercentage;
        protected String url;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T extractId(String extractId) {
            this.extractId = extractId;
            return this.self();
        }

        public T extractMode(ExtractMode extractMode) {
            this.extractMode = extractMode;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T status(String status) {
            this.status = status;
            return this.self();
        }

        public T storageType(String storageType) {
            this.storageType = storageType;
            return this.self();
        }

        public T uploadPercentage(int uploadPercentage) {
            this.uploadPercentage = uploadPercentage;
            return this.self();
        }

        public T url(String url) {
            this.url = url;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public ISOExtraction build() {
            return new ISOExtraction(this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName);
        }

        public T fromISOExtraction(ISOExtraction in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).accountId(in.getAccountId())).created(in.getCreated())).extractId(in.getExtractId())).extractMode(in.getExtractMode())).name(in.getName())).state(in.getState())).status(in.getStatus())).storageType(in.getStorageType())).uploadPercentage(in.getUploadPercentage())).url(in.getUrl())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }
}

