/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Flavor
extends Resource {
    private final int ram;
    private final int disk;
    private final int vcpus;
    private final Optional<String> swap;
    @Named(value="rxtx_factor")
    private final Optional<Double> rxtxFactor;
    @Named(value="OS-FLV-EXT-DATA:ephemeral")
    private final Optional<Integer> ephemeral;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFlavor(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "ram", "disk", "vcpus", "swap", "rxtx_factor", "OS-FLV-EXT-DATA:ephemeral"})
    protected Flavor(String id, String name, Set<Link> links, int ram, int disk, int vcpus, @Nullable String swap, @Nullable Double rxtxFactor, @Nullable Integer ephemeral) {
        super(id, Preconditions.checkNotNull(name, "name"), links);
        Preconditions.checkArgument(ram > 0, "Value of ram has to greater than 0");
        Preconditions.checkArgument(vcpus > 0, "Value of vcpus has to greater than 0");
        this.ram = ram;
        this.disk = disk;
        this.vcpus = vcpus;
        this.swap = Optional.fromNullable(swap);
        this.rxtxFactor = Optional.fromNullable(rxtxFactor);
        this.ephemeral = Optional.fromNullable(ephemeral);
    }

    public int getRam() {
        return this.ram;
    }

    public int getDisk() {
        return this.disk;
    }

    public int getVcpus() {
        return this.vcpus;
    }

    public Optional<String> getSwap() {
        return this.swap;
    }

    public Optional<Double> getRxtxFactor() {
        return this.rxtxFactor;
    }

    public Optional<Integer> getEphemeral() {
        return this.ephemeral;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.ram, this.disk, this.vcpus, this.swap, this.rxtxFactor, this.ephemeral);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Flavor that = (Flavor)Flavor.class.cast(obj);
        return super.equals(that) && Objects.equal(this.ram, that.ram) && Objects.equal(this.disk, that.disk) && Objects.equal(this.vcpus, that.vcpus) && Objects.equal(this.swap, that.swap) && Objects.equal(this.rxtxFactor, that.rxtxFactor) && Objects.equal(this.ephemeral, that.ephemeral);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("ram", this.ram).add("disk", this.disk).add("vcpus", this.vcpus).add("swap", this.swap).add("rxtxFactor", this.rxtxFactor).add("ephemeral", this.ephemeral);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected int ram;
        protected int disk;
        protected int vcpus;
        protected String swap;
        protected Double rxtxFactor;
        protected Integer ephemeral;

        public T ram(int ram) {
            this.ram = ram;
            return (T)((Builder)this.self());
        }

        public T disk(int disk) {
            this.disk = disk;
            return (T)((Builder)this.self());
        }

        public T vcpus(int vcpus) {
            this.vcpus = vcpus;
            return (T)((Builder)this.self());
        }

        public T swap(String swap) {
            this.swap = swap;
            return (T)((Builder)this.self());
        }

        public T rxtxFactor(Double rxtxFactor) {
            this.rxtxFactor = rxtxFactor;
            return (T)((Builder)this.self());
        }

        public T ephemeral(Integer ephemeral) {
            this.ephemeral = ephemeral;
            return (T)((Builder)this.self());
        }

        @Override
        public Flavor build() {
            return new Flavor(this.id, this.name, this.links, this.ram, this.disk, this.vcpus, this.swap, this.rxtxFactor, this.ephemeral);
        }

        public T fromFlavor(Flavor in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).ram(in.getRam())).disk(in.getDisk())).vcpus(in.getVcpus())).swap(in.getSwap().orNull())).rxtxFactor(in.getRxtxFactor().orNull())).ephemeral(in.getEphemeral().orNull());
        }
    }
}

