# Contributing to PyCOMPSs AutoParallel

When contributing to this repository, please first discuss the change you wish to
make via issue, email, or any other method with the owners of this repository. Please,
do it before making a change. 

Please note we have a code of conduct, please follow it in all your interactions
with the project.


## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer
 when doing a build.
2. Update the README.md with details of changes to the interface, this includes new
 environment variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new
 version that this Pull Request would represent. The versioning scheme we use 
 is [SemVer][sem_version].
4. You may merge the Pull Request in once you have the sign-off of two other 
 developers, or if you do not have permission to do that, you may request the
 second reviewer to merge it for you.


## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[sem_version]: http://semver.org/
[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
