#!/usr/bin/python

# -*- coding: utf-8 -*-

# For better print formatting
from __future__ import print_function

# Imports
from pycompss.api.parallel import parallel
from pycompss.api.constraint import constraint
from pycompss.api.task import task
from pycompss.api.api import compss_barrier
from pycompss.api.api import compss_wait_on

import numpy as np


############################################
# MATRIX GENERATION
############################################

def initialize_variables(m_size):
    a = create_matrix(m_size)
    b = create_matrix(m_size)
    c = create_matrix(m_size)

    return a, b, c


def create_matrix(m_size):
    mat = []
    for i in range(m_size):
        mat.append([])
        for _ in range(m_size):
            mb = create_entry()
            mat[i].append(mb)
    return mat


@constraint(ComputingUnits="${ComputingUnits}")
@task(returns=1)
def create_entry():
    import os
    np.random.seed(ord(os.urandom(1)))
    return np.float64(100 * np.random.random())


############################################
# MAIN FUNCTION
############################################

# @parallel()
# [COMPSs Autoparallel] Begin Autogenerated code
import math

from pycompss.api.api import compss_barrier, compss_wait_on, compss_open
from pycompss.api.task import task
from pycompss.api.parameter import *
from pycompss.util.translators.arg_utils.arg_utils import ArgUtils


@task(m_size=IN, t2=IN, beta=IN, c=INOUT, returns="LT3_args_size")
def LT3(m_size, t2, beta, *args):
    global LT3_args_size
    c, = ArgUtils.rebuild_args(args)
    for t3 in range(0, int(math.floor(float(m_size - 1) / float(2))) + 1):
        lbp = 2 * t3
        ubp = min(m_size - 1, 2 * t3 + 1)
        for t4 in range(2 * t3, min(m_size - 1, 2 * t3 + 1) + 1):
            lbv = 2 * t2
            ubv = min(m_size - 1, 2 * t2 + 1)
            for t5 in range(2 * t2, min(m_size - 1, 2 * t2 + 1) + 1):
                c[t5 - 2 * t2][t4 - 0] = S1_no_task(c[t5 - 2 * t2][t4 - 0], beta)
    return ArgUtils.flatten_args(c)


@task(t3=IN, m_size=IN, t4=IN, t2=IN, alpha=IN, a=IN, b=IN, c=INOUT, returns="LT4_args_size")
def LT4(t3, m_size, t4, t2, alpha, *args):
    global LT4_args_size
    a, b, c = ArgUtils.rebuild_args(args)
    for t5 in range(2 * t3, min(m_size - 1, 2 * t3 + 1) + 1):
        lbp = 2 * t4
        ubp = min(m_size - 1, 2 * t4 + 1)
        for t6 in range(2 * t4, min(m_size - 1, 2 * t4 + 1) + 1):
            lbv = 2 * t2
            ubv = min(m_size - 1, 2 * t2 + 1)
            for t7 in range(2 * t2, min(m_size - 1, 2 * t2 + 1) + 1):
                c[t7 - 2 * t2][t5 - 2 * t3] = S2_no_task(c[t7 - 2 * t2][t5 - 2 * t3], alpha, a[t7 - 2 * t2][t6 - 2 *
                    t4], b[t6 - 2 * t4][t5 - 2 * t3])
    return ArgUtils.flatten_args(c)


@task(var2=IN, beta=IN, returns=1)
def S1(var2, beta):
    return scale(var2, beta)


def S1_no_task(var2, beta):
    return scale(var2, beta)


@task(var2=IN, alpha=IN, var3=IN, var4=IN, returns=1)
def S2(var2, alpha, var3, var4):
    return multiply(var2, alpha, var3, var4)


def S2_no_task(var2, alpha, var3, var4):
    return multiply(var2, alpha, var3, var4)


def matmul(a, b, c, m_size, alpha, beta):
    if __debug__:
        a = compss_wait_on(a)
        b = compss_wait_on(b)
        c = compss_wait_on(c)
        print('Matrix A:')
        print(a)
        print('Matrix B:')
        print(b)
        print('Matrix C:')
        print(c)
    if __debug__:
        import copy
        input_a = copy.deepcopy(a)
        input_b = copy.deepcopy(b)
        input_c = copy.deepcopy(c)
        res_expected = seq_multiply(input_a, input_b, input_c, m_size, alpha, beta)
    if m_size >= 1:
        lbp = 0
        ubp = int(math.floor(float(m_size - 1) / float(2)))
        for t2 in range(lbp, ubp + 1):
            lbp = 0
            ubp = int(math.floor(float(m_size - 1) / float(2)))
            LT3_aux_0 = [[c[gv0][gv1] for gv1 in range(0, m_size if m_size >= 0 and -2 + m_size <= 2 * t2 <= m_size else
                m_size, 1)] for gv0 in range(2 * t2, m_size if m_size >= 0 and -2 + m_size <= 2 * t2 <= m_size else 
                2 + 2 * t2, 1)]
            LT3_argutils = ArgUtils()
            global LT3_args_size
            LT3_flat_args, LT3_args_size = LT3_argutils.flatten(1, LT3_aux_0, LT3_aux_0)
            LT3_new_args = LT3(m_size, t2, beta, *LT3_flat_args)
            LT3_aux_0, = LT3_argutils.rebuild(LT3_new_args)
            for gv0 in range(2 * t2, m_size if m_size >= 0 and -2 + m_size <= 2 * t2 <= m_size else 2 + 2 * t2, 1):
                for gv1 in range(0, m_size if m_size >= 0 and -2 + m_size <= 2 * t2 <= m_size else m_size, 1):
                    c[gv0][gv1] = LT3_aux_0[gv0 - 2 * t2][gv1 - 0]
        lbp = 0
        ubp = int(math.floor(float(m_size - 1) / float(2)))
        for t2 in range(lbp, ubp + 1):
            lbp = 0
            ubp = int(math.floor(float(m_size - 1) / float(2)))
            for t3 in range(0, int(math.floor(float(m_size - 1) / float(2))) + 1):
                lbp = 0
                ubp = int(math.floor(float(m_size - 1) / float(2)))
                for t4 in range(0, int(math.floor(float(m_size - 1) / float(2))) + 1):
                    lbp = 2 * t3
                    ubp = min(m_size - 1, 2 * t3 + 1)
                    LT4_aux_0 = [[a[gv0][gv1] for gv1 in range(2 * t4, m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 
                        2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if 2 * t2 <=
                        m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 *
                        t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <=
                        m_size else 2 + 2 * t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and
                        2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 +
                        m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and
                        2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <=
                        m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4, 1)] for gv0 in range(2 * t2, 
                        m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <=
                        m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <=
                        -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <=
                        m_size and -1 + m_size <= 2 * t4 <= m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and
                        -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t2 if m_size >= 3 + 2 *
                        t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t2 if m_size >=
                        3 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t2 if m_size >= 
                        3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 
                        2 * t2, 1)]
                    LT4_aux_1 = [[b[gv0][gv1] for gv1 in range(2 * t3, 2 + 2 * t3 if 2 * t2 <= m_size <= 2 + 2 * t2 and
                        2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3 if 2 * t2 <=
                        m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 *
                        t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <=
                        m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and
                        2 * t4 <= -2 + m_size else 2 + 2 * t3 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and 
                        -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 +
                        m_size and 2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 *
                        t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size, 1)] for gv0 in range(2 * t4, 
                        m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <=
                        m_size else 2 + 2 * t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 *
                        t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <=
                        m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and
                        -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 *
                        t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if m_size >=
                        3 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 
                        2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 *
                        t4, 1)]
                    LT4_aux_2 = [[c[gv0][gv1] for gv1 in range(2 * t3, m_size if m_size >= 3 + 2 * t2 and -1 +
                        m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size if m_size >= 3 + 
                        2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t3 if 
                        m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 
                        2 * t3 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else 
                        m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <=
                        2 * t4 <= m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <=
                        m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t3 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 *
                        t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3, 1)] for gv0 in range(
                        2 * t2, 2 + 2 * t2 if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 +
                        m_size <= 2 * t4 <= m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <=
                        m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 +
                        m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and 2 *
                        t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and
                        -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size if 2 * t2 <=
                        m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else 
                        m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <=
                        m_size else m_size, 1)]
                    LT4_argutils = ArgUtils()
                    global LT4_args_size
                    LT4_flat_args, LT4_args_size = LT4_argutils.flatten(3, LT4_aux_0, LT4_aux_1, LT4_aux_2, LT4_aux_2)
                    LT4_new_args = LT4(t3, m_size, t4, t2, alpha, *LT4_flat_args)
                    LT4_aux_2, = LT4_argutils.rebuild(LT4_new_args)
                    for gv0 in range(2 * t2, m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 
                        -1 + m_size <= 2 * t4 <= m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= 
                        -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 +
                        m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size if 2 * t2 <=
                        m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else 2 + 
                        2 * t2 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size
                         else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size
                         else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <=
                        2 * t4 <= m_size else 2 + 2 * t2, 1):
                        for gv1 in range(2 * t4, m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and
                            -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 *
                            t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 *
                            t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 *
                            t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= 
                            -2 + m_size else m_size if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 +
                            m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 +
                            m_size and 2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 
                            2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4, 1):
                            a[gv0][gv1] = LT4_aux_0[gv0 - 2 * t2][gv1 - 2 * t4]
                    for gv0 in range(2 * t4, m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and 
                        -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <=
                        -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 +
                        m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t4 if 2 * t2 <=
                        m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else 
                        m_size if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size
                         else 2 + 2 * t4 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size
                         else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 
                        2 * t4 <= m_size else 2 + 2 * t4, 1):
                        for gv1 in range(2 * t3, 2 + 2 * t3 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 +
                            m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3 if 2 * t2 <= m_size <= 2 + 2 *
                            t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <=
                            2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 
                            m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <=
                            -2 + m_size else 2 + 2 * t3 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 +
                            m_size <= 2 * t4 <= m_size else 2 + 2 * t3 if m_size >= 3 + 2 * t2 and 2 * t3 <= -2 +
                            m_size and 2 * t4 <= -2 + m_size else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 
                            2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size, 1):
                            b[gv0][gv1] = LT4_aux_1[gv0 - 2 * t4][gv1 - 2 * t3]
                    for gv0 in range(2 * t2, 2 + 2 * t2 if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and
                        -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 *
                        t3 <= m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and 2 * t3 <=
                        -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t2 if m_size >= 3 + 2 * t2 and 
                        2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <= 2 + 2 *
                        t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else m_size if 2 *
                        t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <= -2 + m_size else
                        m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <=
                        m_size else m_size, 1):
                        for gv1 in range(2 * t3, m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and
                            -1 + m_size <= 2 * t4 <= m_size else m_size if m_size >= 3 + 2 * t2 and -1 + m_size <= 2 *
                            t3 <= m_size and 2 * t4 <= -2 + m_size else 2 + 2 * t3 if m_size >= 3 + 2 * t2 and 2 *
                            t3 <= -2 + m_size and -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3 if m_size >= 3 + 2 *
                            t2 and 2 * t3 <= -2 + m_size and 2 * t4 <= -2 + m_size else m_size if 2 * t2 <= m_size <=
                            2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and -1 + m_size <= 2 * t4 <= m_size else 
                            m_size if 2 * t2 <= m_size <= 2 + 2 * t2 and -1 + m_size <= 2 * t3 <= m_size and 2 * t4 <=
                            -2 + m_size else 2 + 2 * t3 if 2 * t2 <= m_size <= 2 + 2 * t2 and 2 * t3 <= -2 + m_size and
                            -1 + m_size <= 2 * t4 <= m_size else 2 + 2 * t3, 1):
                            c[gv0][gv1] = LT4_aux_2[gv0 - 2 * t2][gv1 - 2 * t3]
    compss_barrier()
    if __debug__:
        c = compss_wait_on(c)
        print('New Matrix C:')
        print(c)
    if __debug__:
        check_result(c, res_expected)

# [COMPSs Autoparallel] End Autogenerated code


############################################
# MATHEMATICAL FUNCTIONS
############################################

def scale(c, beta):
    # import time
    # start = time.time()

    return c * beta

    # end = time.time()
    # tm = end - start
    # print "TIME: " + str(tm*1000) + " ms"


def multiply(c, alpha, a, b):
    # import time
    # start = time.time()

    return c + alpha * np.dot(a, b)

    # end = time.time()
    # tm = end - start
    # print "TIME: " + str(tm*1000) + " ms"


############################################
# RESULT CHECK FUNCTIONS
############################################

def seq_multiply(a, b, c, m_size, alpha, beta):
    for i in range(m_size):
        for j in range(m_size):
            c[i][j] *= beta
        for k in range(m_size):
            for j in range(m_size):
                c[i][j] += alpha * np.dot(a[i][k], b[k][j])

    return c


def check_result(result, result_expected):
    is_ok = np.allclose(result, result_expected)
    print("Result check status: " + str(is_ok))

    if not is_ok:
        raise Exception("Result does not match expected result")


############################################
# MAIN
############################################

if __name__ == "__main__":
    # Import libraries
    import time

    # Parse arguments
    import sys

    args = sys.argv[1:]
    MSIZE = int(args[0])
    ALPHA = np.float64(1.5)
    BETA = np.float64(1.2)

    # Log arguments if required
    if __debug__:
        print("Running matmul application with:")
        print(" - MSIZE = " + str(MSIZE))

    # Initialize matrices
    if __debug__:
        print("Initializing matrices")
    start_time = time.time()
    A, B, C = initialize_variables(MSIZE)
    compss_barrier()

    # Begin computation
    if __debug__:
        print("Performing computation")
    mult_start_time = time.time()
    matmul(A, B, C, MSIZE, ALPHA, BETA)
    compss_barrier(True)
    end_time = time.time()

    # Log results and time
    if __debug__:
        print("Post-process results")
    total_time = end_time - start_time
    init_time = mult_start_time - start_time
    mult_time = end_time - mult_start_time

    print("RESULTS -----------------")
    print("VERSION AUTOPARALLEL")
    print("MSIZE " + str(MSIZE))
    print("DEBUG " + str(__debug__))
    print("TOTAL_TIME " + str(total_time))
    print("INIT_TIME " + str(init_time))
    print("MULT_TIME " + str(mult_time))
    print("-------------------------")
