#!/usr/bin/python

# -*- coding: utf-8 -*-

# For better print formatting
from __future__ import print_function

# Imports
from pycompss.api.parallel import parallel
from pycompss.api.constraint import constraint
from pycompss.api.task import task
from pycompss.api.api import compss_barrier
from pycompss.api.api import compss_wait_on

import numpy as np


############################################
# MATRIX GENERATION
############################################

def initialize_variables(n_size):
    a = create_matrix(n_size)

    return a


def create_matrix(n_size):
    mat = []
    for i in range(n_size):
        mat.append([])
        for j in range(n_size):
            mb = create_entry(i, j, n_size)
            mat[i].append(mb)

    return mat


@constraint(ComputingUnits="${ComputingUnits}")
@task(returns=1)
def create_entry(i, j, n_size):
    return np.float64(np.float64(i * (j + 2) + 2) / np.float64(n_size))


############################################
# MAIN FUNCTION
############################################

# @parallel()
# [COMPSs Autoparallel] Begin Autogenerated code
import math

from pycompss.api.api import compss_barrier, compss_wait_on, compss_open
from pycompss.api.task import task
from pycompss.api.parameter import *
from pycompss.util.translators.arg_utils.arg_utils import ArgUtils


@task(t1=IN, t2=IN, n_size=IN, a=INOUT, returns="LT2_args_size")
def LT2(t1, t2, n_size, *args):
    global LT2_args_size
    a, = ArgUtils.rebuild_args(args)
    for t3 in range(max(int(math.ceil(float(t1 + t2) / float(2))), t1 - t2 + 1), int(math.floor(float(t1 + t2 +
        n_size - 1) / float(2))) + 1):
        lbp = max(max(2 * t2, t1 - t2 + 1), -t1 + t2 + 2 * t3 - n_size + 2)
        ubp = min(min(2 * t2 + 1, -t1 + t2 + 2 * t3), t1 - t2 + n_size - 2)
        for t5 in range(max(max(2 * t2, t1 - t2 + 1), -t1 + t2 + 2 * t3 - n_size + 2), min(min(2 * t2 + 1, -t1 + t2 +
            2 * t3), t1 - t2 + n_size - 2) + 1):
            lbp = max(2 * t3, t1 - t2 + t5 + 1)
            ubp = min(2 * t3 + 1, t1 - t2 + t5 + n_size - 2)
            for t6 in range(max(2 * t3, t1 - t2 + t5 + 1), min(2 * t3 + 1, t1 - t2 + t5 + n_size - 2) + 1):
                a[-t1 + t2 + t5 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 -
                    t5 + t6 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)] = S1_no_task(a[-t1 + t2 + t5 - 
                    1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 - 1 -
                    (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)], a[-t1 + t2 + t5 - 1 - (0 if -1 + t1 <= 3 *
                    t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 - (0 if -1 + t1 <= 3 * t2 <=
                    t1 and n_size >= 3 else 0)], a[-t1 + t2 + t5 - 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3
                     else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 + 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else
                    0)], a[-t1 + t2 + t5 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 +
                    t2 - t5 + t6 - 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)], a[-t1 + t2 + t5 - (0 if
                    -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 - (0 if -1 +
                    t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)], a[-t1 + t2 + t5 - (0 if -1 + t1 <= 3 * t2 <= t1 and
                    n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 + 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and 
                    n_size >= 3 else 0)], a[-t1 + t2 + t5 + 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 
                    -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 - 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0
                    )], a[-t1 + t2 + t5 + 1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][
                    -t1 + t2 - t5 + t6 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)], a[-t1 + t2 + t5 + 1 -
                    (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2)][-t1 + t2 - t5 + t6 + 1 - (
                    0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)])
    return ArgUtils.flatten_args(a)


@task(var2=IN, var3=IN, var4=IN, var5=IN, var6=IN, var7=IN, var8=IN, var9=IN, var10=IN, returns=1)
def S1(var2, var3, var4, var5, var6, var7, var8, var9, var10):
    return compute_distance(var2, var3, var4, var5, var6, var7, var8, var9, var10)


def S1_no_task(var2, var3, var4, var5, var6, var7, var8, var9, var10):
    return compute_distance(var2, var3, var4, var5, var6, var7, var8, var9, var10)


def seidel(a, n_size, t_size):
    if __debug__:
        a = compss_wait_on(a)
        print('Matrix A:')
        print(a)
    if __debug__:
        import copy
        a_seq = copy.deepcopy(a)
        a_expected = seq_seidel(a_seq, n_size, t_size)
    if n_size >= 3 and t_size >= 1:
        lbp = 0
        ubp = int(math.floor(float(n_size + 3 * t_size - 5) / float(2)))
        for t1 in range(0, int(math.floor(float(n_size + 3 * t_size - 5) / float(2))) + 1):
            lbp = max(int(math.ceil(float(t1) / float(3))), t1 - t_size + 1)
            ubp = min(int(math.floor(float(t1 + n_size - 2) / float(3))), t1)
            for t2 in range(lbp, ubp + 1):
                lbp = max(int(math.ceil(float(t1 + t2) / float(2))), t1 - t2 + 1)
                ubp = int(math.floor(float(t1 + t2 + n_size - 1) / float(2)))
                LT2_aux_0 = [[a[gv0][gv1] for gv1 in range(0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0, 
                    n_size if 3 * t2 >= -1 + t1 and n_size >= 3 and n_size >= 3 - t1 + 3 * t2 else n_size, 1)] for
                    gv0 in range(0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2, 3 - t1 + 3 * t2 if
                    3 * t2 >= -1 + t1 and n_size >= 3 and n_size >= 3 - t1 + 3 * t2 else n_size, 1)]
                LT2_argutils = ArgUtils()
                global LT2_args_size
                LT2_flat_args, LT2_args_size = LT2_argutils.flatten(1, LT2_aux_0, LT2_aux_0)
                LT2_new_args = LT2(t1, t2, n_size, *LT2_flat_args)
                LT2_aux_0, = LT2_argutils.rebuild(LT2_new_args)
                for gv0 in range(0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 * t2, 3 - t1 + 3 * t2 if
                    3 * t2 >= -1 + t1 and n_size >= 3 and n_size >= 3 - t1 + 3 * t2 else n_size, 1):
                    for gv1 in range(0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0, n_size if 3 * t2 >= -1 +
                        t1 and n_size >= 3 and n_size >= 3 - t1 + 3 * t2 else n_size, 1):
                        a[gv0][gv1] = LT2_aux_0[gv0 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else -1 - t1 + 3 *
                            t2)][gv1 - (0 if -1 + t1 <= 3 * t2 <= t1 and n_size >= 3 else 0)]
    compss_barrier()
    if __debug__:
        a = compss_wait_on(a)
        print('New Matrix A:')
        print(a)
    if __debug__:
        check_result(a, a_expected)

# [COMPSs Autoparallel] End Autogenerated code


############################################
# MATHEMATICAL FUNCTIONS
############################################

def compute_distance(a_tl, a_tc, a_tr, a_cl, a_cc, a_cr, a_bl, a_bc, a_br):
    # import time
    # start = time.time()

    return np.float64((np.float64(a_tl + a_tc + a_tr + a_cl + a_cc + a_cr + a_bl + a_bc + a_br)) / np.float64(9))

    # end = time.time()
    # tm = end - start
    # print "TIME: " + str(tm*1000) + " ms"


############################################
# RESULT CHECK FUNCTIONS
############################################

def seq_seidel(a, n_size, t_size):
    for _ in range(t_size):
        for i in range(1, n_size - 1):
            for j in range(1, n_size - 1):
                a[i][j] = np.float64(np.float64(
                    a[i - 1][j - 1] + a[i - 1][j] + a[i - 1][j + 1] + a[i][j - 1] + a[i][j] + a[i][j + 1] + a[i + 1][
                        j - 1] + a[i + 1][j] + a[i + 1][j + 1]) / np.float64(9))

    return a


def check_result(a, a_expected):
    is_ok = np.allclose(a, a_expected)
    print("Result check status: " + str(is_ok))

    if not is_ok:
        raise Exception("Result does not match expected result")


############################################
# MAIN
############################################

if __name__ == "__main__":
    # Import libraries
    import time

    # Parse arguments
    import sys

    args = sys.argv[1:]
    NSIZE = int(args[0])
    TSIZE = int(args[1])

    # Log arguments if required
    if __debug__:
        print("Running seidel application with:")
        print(" - NSIZE = " + str(NSIZE))
        print(" - TSIZE = " + str(TSIZE))

    # Initialize matrices
    if __debug__:
        print("Initializing matrices")
    start_time = time.time()
    A = initialize_variables(NSIZE)
    compss_barrier()

    # Begin computation
    if __debug__:
        print("Performing computation")
    seidel_start_time = time.time()
    seidel(A, NSIZE, TSIZE)
    compss_barrier(True)
    end_time = time.time()

    # Log results and time
    if __debug__:
        print("Post-process results")
    total_time = end_time - start_time
    init_time = seidel_start_time - start_time
    seidel_time = end_time - seidel_start_time

    print("RESULTS -----------------")
    print("VERSION AUTOPARALLEL")
    print("NSIZE " + str(NSIZE))
    print("TSIZE " + str(TSIZE))
    print("DEBUG " + str(__debug__))
    print("TOTAL_TIME " + str(total_time))
    print("INIT_TIME " + str(init_time))
    print("SEIDEL_TIME " + str(seidel_time))
    print("-------------------------")
