/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ImageParser
implements Function<org.jclouds.ec2.domain.Image, Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<Image.ImageState, Image.Status> toPortableImageStatus;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialProvider;
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Location> defaultLocation;
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    private final ReviseParsedImage reviseParsedImage;

    @Inject
    public EC2ImageParser(Map<Image.ImageState, Image.Status> toPortableImageStatus, PopulateDefaultLoginCredentialsForImageStrategy credentialProvider, Map<OsFamily, Map<String, String>> osVersionMap, @Memoized Supplier<Set<? extends Location>> locations, Supplier<Location> defaultLocation, ReviseParsedImage reviseParsedImage) {
        this.toPortableImageStatus = Preconditions.checkNotNull(toPortableImageStatus, "toPortableImageStatus");
        this.credentialProvider = Preconditions.checkNotNull(credentialProvider, "credentialProvider");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.defaultLocation = Preconditions.checkNotNull(defaultLocation, "defaultLocation");
        this.osVersionMap = Preconditions.checkNotNull(osVersionMap, "osVersionMap");
        this.reviseParsedImage = Preconditions.checkNotNull(reviseParsedImage, "reviseParsedImage");
    }

    @Override
    public Image apply(final org.jclouds.ec2.domain.Image from) {
        if (from.getImageType() != Image.ImageType.MACHINE) {
            return null;
        }
        ImageBuilder builder = new ImageBuilder();
        builder.providerId(from.getId());
        builder.id(from.getRegion() + "/" + from.getId());
        builder.name(from.getName());
        builder.description(from.getDescription() != null ? from.getDescription() : from.getImageLocation());
        builder.userMetadata(ImmutableMap.builder().put("owner", from.getImageOwnerId()).put("rootDeviceType", from.getRootDeviceType().value()).put("virtualizationType", from.getVirtualizationType().value()).put("hypervisor", from.getHypervisor().value()).build());
        OperatingSystem.Builder osBuilder = OperatingSystem.builder();
        osBuilder.is64Bit(from.getArchitecture() == Image.Architecture.X86_64);
        OsFamily family = this.parseOsFamily(from);
        osBuilder.family(family);
        osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString(family, from.getImageLocation(), this.osVersionMap));
        osBuilder.description(from.getImageLocation());
        osBuilder.arch(from.getVirtualizationType().value());
        this.reviseParsedImage.reviseParsedImage(from, builder, family, osBuilder);
        builder.defaultCredentials(this.credentialProvider.apply(from));
        try {
            builder.location(Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

                @Override
                public boolean apply(Location input) {
                    return input.getId().equals(from.getRegion());
                }
            }));
        }
        catch (NoSuchElementException e) {
            this.logger.error("unknown region %s for image %s; not in %s", from.getRegion(), from.getId(), this.locations);
            builder.location(new LocationBuilder().scope(LocationScope.REGION).id(from.getRegion()).description(from.getRegion()).parent(this.defaultLocation.get()).build());
        }
        builder.operatingSystem(osBuilder.build());
        builder.status(this.toPortableImageStatus.get((Object)from.getImageState()));
        builder.backendStatus(from.getRawState());
        return builder.build();
    }

    private OsFamily parseOsFamily(org.jclouds.ec2.domain.Image from) {
        if (from.getPlatform() != null && from.getPlatform().equalsIgnoreCase("windows")) {
            return OsFamily.WINDOWS;
        }
        OsFamily family = ComputeServiceUtils.parseOsFamilyOrUnrecognized(from.getImageLocation());
        if (family == OsFamily.UNRECOGNIZED && from.getPlatform() != null) {
            family = ComputeServiceUtils.parseOsFamilyOrUnrecognized(from.getPlatform());
        }
        return family;
    }
}

