/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Drive;

@Singleton
public class BaseDriveToMap
implements Function<Drive, Map<String, String>> {
    @Override
    public Map<String, String> apply(Drive from) {
        Preconditions.checkNotNull(from, "drive");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("name", from.getName());
        builder.put("size", from.getSize() + "");
        if (from.getClaimType() != ClaimType.EXCLUSIVE) {
            builder.put("claim:type", from.getClaimType().toString());
        }
        if (!from.getReaders().isEmpty()) {
            builder.put("readers", Joiner.on(' ').join(from.getReaders()));
        }
        if (!from.getTags().isEmpty()) {
            builder.put("tags", Joiner.on(' ').join(from.getTags()));
        }
        for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
            builder.put("user:" + entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

