/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class ServerToMap
implements Function<Server, Map<String, String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    @ApiVersion
    private final String apiVersion;

    @Inject
    public ServerToMap(@ApiVersion String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, String> apply(Server from) {
        Preconditions.checkNotNull(from, "server");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("name", from.getName());
        builder.put("cpu", from.getCpu() + "");
        if (from.getSmp() != null) {
            builder.put("smp", from.getSmp() + "");
        } else {
            builder.put("smp", "auto");
        }
        builder.put("mem", from.getMem() + "");
        builder.put("persistent", from.isPersistent() + "");
        if (!from.getBootDeviceIds().isEmpty()) {
            builder.put("boot", Joiner.on(' ').join(from.getBootDeviceIds()));
        }
        for (Map.Entry<String, Device> entry : from.getDevices().entrySet()) {
            builder.put(entry.getKey(), entry.getValue().getDriveUuid());
            builder.put(entry.getKey() + ":media", entry.getValue().getMediaType().toString());
        }
        int nicId = 0;
        for (NIC nic : from.getNics()) {
            builder.put("nic:" + nicId + ":model", nic.getModel().toString());
            if (nic.getDhcp() != null) {
                builder.put("nic:" + nicId + ":dhcp", nic.getDhcp());
            }
            if (nic.getVlan() != null) {
                builder.put("nic:" + nicId + ":vlan", nic.getVlan());
            }
            if (nic.getMac() != null) {
                this.logger.trace("setting mac on network interfaces not supported: %s", nic);
            }
            ++nicId;
        }
        String vncIp = from.getVnc().getIp();
        if (this.apiVersion.equals("2.0")) {
            builder.put("vnc", "auto");
        } else {
            builder.put("vnc:ip", vncIp == null ? "auto" : vncIp);
        }
        if (from.getVnc().getPassword() != null) {
            builder.put("password", from.getVnc().getPassword());
        }
        if (from.getVnc().isTls()) {
            builder.put("vnc:tls", "on");
        }
        if (!from.getTags().isEmpty()) {
            builder.put("tags", Joiner.on(' ').join(from.getTags()));
        }
        for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
            builder.put("user:" + entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

