/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.auth.NoAgentException;
import com.trilead.ssh2.auth.SshAgentClient;
import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketServiceAccept;
import com.trilead.ssh2.packets.PacketServiceRequest;
import com.trilead.ssh2.packets.PacketUserauthBanner;
import com.trilead.ssh2.packets.PacketUserauthFailure;
import com.trilead.ssh2.packets.PacketUserauthInfoRequest;
import com.trilead.ssh2.packets.PacketUserauthInfoResponse;
import com.trilead.ssh2.packets.PacketUserauthRequestInteractive;
import com.trilead.ssh2.packets.PacketUserauthRequestNone;
import com.trilead.ssh2.packets.PacketUserauthRequestPassword;
import com.trilead.ssh2.packets.PacketUserauthRequestPublicKey;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.DSAPrivateKey;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.DSASignature;
import com.trilead.ssh2.signature.RSAPrivateKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.signature.RSASignature;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Vector;

public class AuthenticationManager
implements MessageHandler {
    private static final Logger log = Logger.getLogger(AuthenticationManager.class);
    TransportManager tm;
    Vector<byte[]> packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = new String[0];
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager tm) {
        this.tm = tm;
    }

    boolean methodPossible(String methName) {
        if (this.remainingMethods == null) {
            return false;
        }
        for (int i = 0; i < this.remainingMethods.length; ++i) {
            if (this.remainingMethods[i].compareTo(methName) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() throws IOException {
        Vector<byte[]> vector = this.packets;
        synchronized (vector) {
            while (this.packets.size() == 0) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("The connection is closed.").initCause(this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException ign) {}
            }
            byte[] res = this.packets.firstElement();
            this.packets.removeElementAt(0);
            return res;
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] msg;
        while ((msg = this.deQueue())[0] == 53) {
            PacketUserauthBanner sb = new PacketUserauthBanner(msg, 0, msg.length);
            this.banner = sb.getBanner();
        }
        return msg;
    }

    public String[] getRemainingMethods(String user) throws IOException {
        this.initialize(user);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String user) throws IOException {
        if (!this.initDone) {
            log.log(10, "Initializing for user " + user);
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest sr = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(sr.getPayload());
            PacketUserauthRequestNone urn = new PacketUserauthRequestNone("ssh-connection", user);
            this.tm.sendMessage(urn.getPayload());
            byte[] msg = this.getNextMessage();
            new PacketServiceAccept(msg, 0, msg.length);
            msg = this.getNextMessage();
            this.initDone = true;
            if (msg[0] == 52) {
                this.authenticated = true;
                log.log(10, "Success!");
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (msg[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(msg, 0, msg.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                log.log(10, Arrays.toString(this.remainingMethods));
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + msg[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticatePublicKey(String user) throws IOException {
        SshAgentClient sshAgentClient = null;
        try {
            int i;
            this.initialize(user);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            try {
                sshAgentClient = new SshAgentClient();
            }
            catch (NoAgentException e) {
                log.log(90, "Could not create SshAgentClient: " + e);
                boolean bl = false;
                if (sshAgentClient != null) {
                    sshAgentClient.close();
                }
                return bl;
            }
            int numKeys = sshAgentClient.getNumKeys();
            int suitableKey = -1;
            for (i = 0; i < numKeys; ++i) {
                byte[] blob = sshAgentClient.getBlob(i);
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, blob);
                this.tm.sendMessage(ua.getPayload());
                byte[] ar = this.getNextMessage();
                if (ar[0] == 60) {
                    log.log(90, "Found suitable key at index " + i);
                    suitableKey = i;
                    break;
                }
                if (ar[0] == 51) continue;
                throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
            }
            if (suitableKey < 0) {
                i = 0;
                return i != 0;
            }
            TypesWriter tw = new TypesWriter();
            byte[] H = this.tm.getSessionIdentifier();
            tw.writeString(H, 0, H.length);
            tw.writeByte(50);
            tw.writeString(user);
            tw.writeString("ssh-connection");
            tw.writeString("publickey");
            tw.writeBoolean(true);
            byte[] blob = sshAgentClient.getBlob(suitableKey);
            tw.writeBytes(blob);
            byte[] msg = tw.getBytes();
            byte[] ds_enc = sshAgentClient.generateSignature(msg, suitableKey);
            PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, blob, ds_enc);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                boolean bl = true;
                return bl;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                boolean bl = false;
                return bl;
            }
            try {
                throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
            }
            catch (IOException e) {
                this.tm.close(e, false);
                throw (IOException)new IOException("Publickey authentication with ssh-agent failed.").initCause(e);
            }
        }
        finally {
            if (sshAgentClient != null) {
                sshAgentClient.close();
            }
        }
    }

    public boolean authenticatePublicKey(String user, char[] PEMPrivateKey, String password, SecureRandom rnd) throws IOException {
        try {
            byte[] enc;
            Object ds;
            byte[] pk_enc;
            Object pk;
            this.initialize(user);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            Object key = PEMDecoder.decode(PEMPrivateKey, password);
            TypesWriter tw = new TypesWriter();
            if (key instanceof DSAPrivateKey) {
                pk = (DSAPrivateKey)key;
                pk_enc = DSASHA1Verify.encodeSSHDSAPublicKey(((DSAPrivateKey)pk).getPublicKey());
                tw.writeString("ssh-dss");
                log.log(10, "public key = " + ((DSAPrivateKey)pk).getPublicKey().toString());
            } else if (key instanceof RSAPrivateKey) {
                pk = (RSAPrivateKey)key;
                pk_enc = RSASHA1Verify.encodeSSHRSAPublicKey(((RSAPrivateKey)pk).getPublicKey());
                tw.writeString("ssh-rsa");
                log.log(10, "public key = " + ((RSAPrivateKey)pk).getPublicKey().toString());
            } else {
                throw new IOException("Unknown private key type returned by the PEM decoder.");
            }
            tw.writeString(pk_enc, 0, pk_enc.length);
            byte[] blob = tw.getBytes();
            log.log(10, "blob size from private key = " + blob.length);
            tw = new TypesWriter();
            byte[] H = this.tm.getSessionIdentifier();
            tw.writeString(H, 0, H.length);
            tw.writeByte(50);
            tw.writeString(user);
            tw.writeString("ssh-connection");
            tw.writeString("publickey");
            tw.writeBoolean(true);
            tw.writeBytes(blob);
            byte[] msg = tw.getBytes();
            if (key instanceof DSAPrivateKey) {
                ds = DSASHA1Verify.generateSignature(msg, (DSAPrivateKey)key, rnd);
                enc = DSASHA1Verify.encodeSSHDSASignature((DSASignature)ds);
                log.log(10, "DSASHA1Verify.encodeSSHDSASignature gives " + enc.length + " bytes");
            } else {
                ds = RSASHA1Verify.generateSignature(msg, (RSAPrivateKey)key);
                enc = RSASHA1Verify.encodeSSHRSASignature((RSASignature)ds);
            }
            PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, blob, enc);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw (IOException)new IOException("Publickey authentication failed.").initCause(e);
        }
    }

    public boolean authenticateNone(String user) throws IOException {
        try {
            this.initialize(user);
            return this.authenticated;
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw (IOException)new IOException("None authentication failed.").initCause(e);
        }
    }

    public boolean authenticatePassword(String user, String pass) throws IOException {
        try {
            this.initialize(user);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword ua = new PacketUserauthRequestPassword("ssh-connection", user, pass);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw (IOException)new IOException("Password authentication failed.").initCause(e);
        }
    }

    public boolean authenticateInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        try {
            byte[] ar;
            this.initialize(user);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (submethods == null) {
                submethods = new String[]{};
            }
            PacketUserauthRequestInteractive ua = new PacketUserauthRequestInteractive("ssh-connection", user, submethods);
            this.tm.sendMessage(ua.getPayload());
            while (true) {
                String[] responses;
                if ((ar = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (ar[0] == 51) {
                    PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                    this.remainingMethods = puf.getAuthThatCanContinue();
                    this.isPartialSuccess = puf.isPartialSuccess();
                    return false;
                }
                if (ar[0] != 60) break;
                PacketUserauthInfoRequest pui = new PacketUserauthInfoRequest(ar, 0, ar.length);
                try {
                    responses = cb.replyToChallenge(pui.getName(), pui.getInstruction(), pui.getNumPrompts(), pui.getPrompt(), pui.getEcho());
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Exception in callback.").initCause(e);
                }
                if (responses == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse puir = new PacketUserauthInfoResponse(responses);
                this.tm.sendMessage(puir.getPayload());
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw (IOException)new IOException("Keyboard-interactive authentication failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        Vector<byte[]> vector = this.packets;
        synchronized (vector) {
            if (msg == null) {
                this.connectionClosed = true;
            } else {
                byte[] tmp = new byte[msglen];
                System.arraycopy(msg, 0, tmp, 0, msglen);
                this.packets.addElement(tmp);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }
}

