/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sshtrilead;

import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileOutputStreamCpi;
import org.gridlab.gat.io.cpi.sshtrilead.SshTrileadFileAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshTrileadFileOutputStreamAdaptor
extends FileOutputStreamCpi {
    protected static Logger logger = LoggerFactory.getLogger(SshTrileadFileOutputStreamAdaptor.class);
    private SshTrileadFileAdaptor file;
    private Session session;
    private OutputStream sessionInputStream;
    private OutputStreamRunner job;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileOutputStreamCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("flush", true);
        capabilities.put("write", true);
        return capabilities;
    }

    public static String getDescription() {
        return "The SshTrilead FileOutputStream Adaptor implements the FileOutputStream object using the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileOutputStreamCpi.getSupportedPreferences();
        preferences.put("sshtrilead.caching.iswindows", (Object)"true");
        preferences.put("sshtrilead.caching.iscsh", (Object)"true");
        preferences.put("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.tcp.nodelay", (Object)"false");
        preferences.put("sshtrilead.use.cached.connections", (Object)"true");
        preferences.put("sshtrilead.connect.timeout", (Object)"5000");
        preferences.put("sshtrilead.kex.timeout", (Object)"5000");
        preferences.put("sshtrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sshtrilead.noHostKeyChecking", (Object)"true");
        preferences.put("file.chmod", (Object)"0700");
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        return preferences;
    }

    public static String[] getSupportedSchemes() {
        return SshTrileadFileAdaptor.getSupportedSchemes();
    }

    public SshTrileadFileOutputStreamAdaptor(GATContext gatContext, URI location, Boolean append) throws GATObjectCreationException, GATInvocationException {
        super(gatContext, location, append);
        if (location.refersToLocalHost()) {
            throw new GATObjectCreationException("this adaptor cannot write local files");
        }
        this.file = new SshTrileadFileAdaptor(gatContext, location);
        if (this.file.exists()) {
            if (this.file.isDirectory()) {
                throw new GATObjectCreationException("cannot write to directory");
            }
            if (!this.file.canWrite()) {
                throw new GATObjectCreationException("cannot write file");
            }
        } else if (!this.file.createNewFile()) {
            throw new GATObjectCreationException("cannot create file");
        }
        try {
            this.session = this.file.getSession();
        }
        catch (Throwable e) {
            throw new GATObjectCreationException("Could not create stream", e);
        }
        this.sessionInputStream = this.session.getStdin();
        String command = "cat " + (append != false ? ">>" : ">") + SshTrileadFileAdaptor.protectAgainstShellMetas(this.file.getFixedPath());
        this.job = new OutputStreamRunner(command);
        this.job.setDaemon(true);
        this.job.start();
    }

    public void close() throws GATInvocationException {
        if (this.session != null) {
            try {
                this.sessionInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.session = null;
        }
    }

    public void flush() throws GATInvocationException {
        if (this.session == null) {
            throw new GATInvocationException("SshTrileadFileOutputStreamAdaptor: file already closed");
        }
        try {
            this.sessionInputStream.flush();
        }
        catch (IOException e) {
            throw new GATInvocationException("flush gave exception", (Throwable)e);
        }
    }

    public void write(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        if (this.session == null) {
            throw new GATInvocationException("SshTrileadFileOutputStreamAdaptor: file already closed");
        }
        try {
            this.sessionInputStream.write(arg0, arg1, arg2);
        }
        catch (IOException e) {
            throw new GATInvocationException("flush gave exception", (Throwable)e);
        }
    }

    public void write(byte[] arg0) throws GATInvocationException {
        if (this.session == null) {
            throw new GATInvocationException("SshTrileadFileOutputStreamAdaptor: file already closed");
        }
        try {
            this.sessionInputStream.write(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("flush gave exception", (Throwable)e);
        }
    }

    public void write(int arg0) throws GATInvocationException {
        if (this.session == null) {
            throw new GATInvocationException("SshTrileadFileOutputStreamAdaptor: file already closed");
        }
        try {
            this.sessionInputStream.write(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("flush gave exception", (Throwable)e);
        }
    }

    private class OutputStreamRunner
    extends Thread {
        private final String command;

        public OutputStreamRunner(String command) {
            this.command = command;
        }

        public void run() {
            try {
                this.execCommand(this.command);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] execCommand(String cmd) throws Exception {
            try {
                String line;
                String line2;
                String[] result = new String[3];
                if (logger.isInfoEnabled()) {
                    logger.info("command: " + cmd);
                }
                SshTrileadFileOutputStreamAdaptor.this.session.execCommand(cmd);
                StreamGobbler stdout = new StreamGobbler(SshTrileadFileOutputStreamAdaptor.this.session.getStdout());
                StreamGobbler stderr = new StreamGobbler(SshTrileadFileOutputStreamAdaptor.this.session.getStderr());
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout));
                StringBuffer out = new StringBuffer();
                while ((line2 = br.readLine()) != null) {
                    out.append(line2);
                    out.append("\n");
                }
                result[0] = out.toString();
                br = new BufferedReader(new InputStreamReader((InputStream)stderr));
                StringBuffer err = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    err.append(line);
                    err.append("\n");
                }
                result[1] = err.toString();
                while (SshTrileadFileOutputStreamAdaptor.this.session.getExitStatus() == null) {
                    Thread.sleep(50L);
                }
                result[2] = "" + SshTrileadFileOutputStreamAdaptor.this.session.getExitStatus();
                if (logger.isDebugEnabled()) {
                    logger.debug("STDOUT: " + result[0]);
                    logger.debug("STDERR: " + result[1]);
                    logger.debug("EXIT:   " + result[2]);
                }
                String[] stringArray = result;
                return stringArray;
            }
            finally {
                SshTrileadFileOutputStreamAdaptor.this.session.close();
            }
        }
    }
}

