/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.sshtrilead;

import com.trilead.ssh2.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshTrileadJob
extends JobCpi {
    private static final long serialVersionUID = -4510717445792377245L;
    protected static Logger logger = LoggerFactory.getLogger(SshTrileadJob.class);
    MetricDefinition statusMetricDefinition;
    Metric statusMetric;
    private Session session;
    private int exitStatus = -1;

    protected SshTrileadJob(GATContext gatContext, JobDescription description, Sandbox sandbox) {
        super(gatContext, description, sandbox);
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected synchronized void setState(Job.JobState state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        MetricEvent v = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
        this.fireMetric(v);
    }

    public synchronized Map<String, Object> getInfo() throws GATInvocationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("state", this.state.toString());
        if (this.state != Job.JobState.RUNNING) {
            m.put("hostname", null);
        } else {
            m.put("hostname", "not available");
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN) {
            m.put("submissiontime", null);
        } else {
            m.put("adaptor.job.id", "" + this.jobID);
            m.put("submissiontime", this.submissiontime);
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN || this.state == Job.JobState.SCHEDULED) {
            m.put("starttime", null);
        } else {
            m.put("starttime", this.starttime);
        }
        if (this.state != Job.JobState.STOPPED) {
            m.put("stoptime", null);
        } else {
            m.put("stoptime", this.stoptime);
        }
        m.put("poststage.exception", (Object)this.postStageException);
        m.put("resourcebroker", "SshTrilead");
        try {
            m.put("exitvalue", "" + this.getExitStatus());
        }
        catch (GATInvocationException gATInvocationException) {
            // empty catch block
        }
        if (this.deleteException != null) {
            m.put("delete.exception", (Object)this.deleteException);
        }
        if (this.wipeException != null) {
            m.put("wipe.exception", (Object)this.wipeException);
        }
        return m;
    }

    public synchronized int getExitStatus() throws GATInvocationException {
        if (this.state != Job.JobState.STOPPED && this.state != Job.JobState.SUBMISSION_ERROR) {
            throw new GATInvocationException("not in STOPPED or SUBMISSION_ERROR state");
        }
        return this.exitStatus;
    }

    public synchronized void stop() throws GATInvocationException {
        this.stop(this.gatContext.getPreferences().containsKey("job.stop.poststage") && this.gatContext.getPreferences().get("job.stop.poststage").equals("false"));
    }

    private synchronized void stop(boolean skipPostStage) throws GATInvocationException {
        if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
            return;
        }
        if (this.session != null) {
            this.session.close();
        }
        if (!skipPostStage) {
            this.setState(Job.JobState.POST_STAGING);
            this.sandbox.retrieveAndCleanup((JobCpi)this);
        }
        this.setState(Job.JobState.STOPPED);
        this.finished();
    }

    public OutputStream getStdin() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdinEnabled()) {
            return this.session.getStdin();
        }
        throw new GATInvocationException("stdin streaming is not enabled!");
    }

    public InputStream getStdout() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdoutEnabled()) {
            return this.session.getStdout();
        }
        throw new GATInvocationException("stdout streaming is not enabled!");
    }

    public InputStream getStderr() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStderrEnabled()) {
            return this.session.getStderr();
        }
        throw new GATInvocationException("stderr streaming is not enabled!");
    }

    protected void monitorState(StreamForwarder stdout, StreamForwarder stderr) {
        new StateMonitor(stdout, stderr);
    }

    class StateMonitor
    extends Thread {
        final StreamForwarder stdout;
        final StreamForwarder stderr;

        StateMonitor(StreamForwarder stdout, StreamForwarder stderr) {
            this.setName("ssh state monitor: " + SshTrileadJob.this.jobDescription.getSoftwareDescription().getExecutable());
            this.setDaemon(true);
            this.stdout = stdout;
            this.stderr = stderr;
            this.start();
        }

        public void run() {
            block7: {
                block6: {
                    SshTrileadJob.this.session.waitForCondition(32, 0L);
                    if (this.stdout != null) {
                        this.stdout.waitUntilFinished();
                        this.stdout.close();
                    }
                    if (this.stderr != null) {
                        this.stderr.waitUntilFinished();
                        this.stderr.close();
                    }
                    try {
                        SshTrileadJob.this.exitStatus = SshTrileadJob.this.session.getExitStatus();
                    }
                    catch (NullPointerException e) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug("unable to retrieve exit status");
                    }
                }
                try {
                    SshTrileadJob.this.stop(false);
                }
                catch (GATInvocationException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("unable to stop job: " + (Object)((Object)e));
                }
            }
        }
    }
}

