/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import ibis.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ProcessRunner.class);
    private ProcessBuilder builder = new ProcessBuilder(new String[0]);
    private Process process = null;
    private int exitStatus;
    private boolean done = false;
    private int processID;

    public ProcessRunner(String exe, String[] args, File dir, Map<String, Object> env) {
        this.builder.command().add(exe);
        if (args != null) {
            for (String arg : args) {
                this.builder.command().add(arg);
            }
        }
        this.builder.directory(dir);
        if (env != null) {
            Map<String, String> e = this.builder.environment();
            e.clear();
            for (Map.Entry<String, Object> entry : env.entrySet()) {
                this.builder.environment().put(entry.getKey(), (String)entry.getValue());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created local ProcessRunner for: " + this.builder.command());
        }
    }

    public void startProcess() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting local process: " + this.builder.command());
        }
        this.process = this.builder.start();
        Field f = null;
        try {
            f = this.process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            this.processID = Integer.parseInt(f.get(this.process).toString());
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ThreadPool.createNew((Runnable)this, (String)"ProcessWaiter");
    }

    public OutputStream getStdin() {
        return this.process.getOutputStream();
    }

    public InputStream getStdout() {
        return this.process.getInputStream();
    }

    public InputStream getStderr() {
        return this.process.getErrorStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.exitStatus = this.process.exitValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Local process done: " + this.builder.command());
        }
        ProcessRunner processRunner = this;
        synchronized (processRunner) {
            this.done = true;
            this.notifyAll();
        }
    }

    public synchronized int getExitStatus() {
        while (!this.done) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
        return this.exitStatus;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public synchronized boolean done() {
        return this.done;
    }

    public synchronized void waitFor() {
        while (!this.done) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
    }

    public int getProcessID() {
        return this.processID;
    }
}

