/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.attributes;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.attributes.BasicFileAttributes;
import org.gridlab.gat.io.attributes.GroupPrincipal;
import org.gridlab.gat.io.attributes.PosixFileAttributeView;
import org.gridlab.gat.io.attributes.PosixFileAttributes;
import org.gridlab.gat.io.attributes.UserPrincipal;
import org.gridlab.gat.io.cpi.attributes.AbstractBasicFileAttributeView;

public abstract class AbstractPosixFileAttributeView
extends AbstractBasicFileAttributeView
implements PosixFileAttributeView {
    private static final String PERMISSIONS_NAME = "permissions";
    private static final String OWNER_NAME = "owner";
    private static final String GROUP_NAME = "group";

    public AbstractPosixFileAttributeView(URI location, boolean followSymbolicLinks) {
        super(location, followSymbolicLinks);
    }

    @Override
    public String name() {
        return "posix";
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        Object attributeValue = super.getAttribute(attribute);
        if (attributeValue == null) {
            if (attribute.equals(PERMISSIONS_NAME)) {
                attributeValue = this.readAttributes().permissions();
            }
            if (attribute.equals(OWNER_NAME)) {
                attributeValue = this.readAttributes().owner();
            }
            if (attribute.equals(GROUP_NAME)) {
                attributeValue = this.readAttributes().group();
            }
        }
        return attributeValue;
    }

    @Override
    public void setAttribute(String attribute, Object value) throws IOException {
        if (attribute.equals(PERMISSIONS_NAME)) {
            this.setPermissions((Set)value);
            return;
        }
        if (attribute.equals(OWNER_NAME)) {
            this.setOwner((UserPrincipal)value);
            return;
        }
        if (attribute.equals(GROUP_NAME)) {
            this.setGroup((GroupPrincipal)value);
            return;
        }
        super.setAttribute(attribute, value);
    }

    public UserPrincipal getOwner() throws IOException {
        return (UserPrincipal)this.getAttribute(OWNER_NAME);
    }

    public Map<String, ?> readAttributes(String first, String ... rest) throws IOException {
        HashSet<String> requestedAttributesNames = new HashSet<String>();
        boolean copyAll = false;
        if (first.equals("*")) {
            copyAll = true;
        } else {
            requestedAttributesNames.add(first);
            for (String attribute : rest) {
                if (attribute.equals("*")) {
                    copyAll = true;
                    break;
                }
                requestedAttributesNames.add(attribute);
            }
        }
        PosixFileAttributes posixFileAttributes = this.readAttributes();
        Map<String, Object> attributes = this.getAttributesMap(posixFileAttributes);
        if (copyAll) {
            return attributes;
        }
        Iterator<String> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String attributeName = iterator.next();
            if (requestedAttributesNames.contains(attributeName)) continue;
            iterator.remove();
        }
        return attributes;
    }

    protected Map<String, Object> getAttributesMap(PosixFileAttributes posixFileAttributes) {
        Map<String, Object> attributes = super.getAttributesMap((BasicFileAttributes)posixFileAttributes);
        attributes.put(PERMISSIONS_NAME, posixFileAttributes.permissions());
        attributes.put(OWNER_NAME, posixFileAttributes.owner());
        attributes.put(GROUP_NAME, posixFileAttributes.group());
        return attributes;
    }
}

