/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.io.File;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.PreStagedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreStagedFileSet {
    protected static Logger logger = LoggerFactory.getLogger(PreStagedFileSet.class);
    private GATContext gatContext;
    private JobDescription description;
    private String authority;
    private String sandbox;
    private boolean preStageStdin;
    private PreStagedFile[] files = new PreStagedFile[0];

    public PreStagedFileSet() {
    }

    public PreStagedFile[] getFiles() {
        return this.files;
    }

    public void setFiles(PreStagedFile[] files) {
        this.files = files;
    }

    public PreStagedFileSet(GATContext gatContext, JobDescription description, String authority, String sandbox, boolean preStageStdin) throws GATInvocationException {
        this.gatContext = gatContext;
        this.description = description;
        this.authority = authority;
        this.sandbox = sandbox;
        this.preStageStdin = preStageStdin;
        this.resolve();
        if (logger.isInfoEnabled()) {
            logger.info(this.toString());
        }
    }

    private void resolve() throws GATInvocationException {
        File stdin;
        SoftwareDescription sd = this.description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        String exe = sd.getExecutable();
        if (exe == null) {
            throw new GATInvocationException("The job description does not contain an executable location");
        }
        ArrayList<PreStagedFile> tmp = new ArrayList<PreStagedFile>();
        Map pre = sd.getPreStaged();
        if (pre != null) {
            Set keys = pre.keySet();
            for (File srcFile : keys) {
                File destFile = (File)pre.get(srcFile);
                tmp.add(new PreStagedFile(this.gatContext, srcFile, destFile, this.authority, this.sandbox, false, exe));
            }
        }
        if (this.preStageStdin && (stdin = sd.getStdin()) != null) {
            tmp.add(new PreStagedFile(this.gatContext, stdin, null, this.authority, this.sandbox, true, exe));
        }
        if (this.description instanceof WrapperJobDescription) {
            try {
                File wrapperInfoFile = ((WrapperJobDescription)this.description).getInfoFile(this.gatContext);
                tmp.add(new PreStagedFile(this.gatContext, wrapperInfoFile, GAT.createFile((GATContext)this.gatContext, (String)"wrapper.info"), this.authority, this.sandbox, false, exe));
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Could not create prestage description for wrapper info", (Throwable)e);
            }
        }
        this.files = tmp.toArray(new PreStagedFile[0]);
    }

    protected void prestage() throws GATInvocationException {
        SoftwareDescription sd = this.description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.files[i].prestage();
                continue;
            }
            catch (Throwable e) {
                if (logger.isInfoEnabled()) {
                    logger.info("prestage failed, removing already staged files: ", e);
                }
                throw new GATInvocationException("resource broker cpi", e);
            }
        }
    }

    public void delete() throws GATInvocationException {
        GATInvocationException e = new GATInvocationException();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.files[i].delete();
                continue;
            }
            catch (Exception x) {
                e.add("resource broker", (Throwable)x);
            }
        }
        if (e.getNrChildren() != 0) {
            throw e;
        }
    }

    public void wipe() throws GATInvocationException {
        GATInvocationException e = new GATInvocationException();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.files[i].wipe();
                continue;
            }
            catch (Exception x) {
                e.add("resource broker", (Throwable)x);
            }
        }
        if (e.getNrChildren() != 0) {
            throw e;
        }
    }

    PreStagedFile getStdin() {
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].isStdIn()) continue;
            return this.files[i];
        }
        return null;
    }

    PreStagedFile getExecutable() {
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].isExecutable()) continue;
            return this.files[i];
        }
        return null;
    }

    public int size() {
        return this.files.length;
    }

    public PreStagedFile getFile(int pos) {
        return this.files[pos];
    }

    public String toString() {
        String res = "";
        res = res + "PreStagedFileSet:\n";
        for (int i = 0; i < this.files.length; ++i) {
            res = res + this.files[i] + "\n";
        }
        return res;
    }

    void setGatContext(GATContext gatContext) {
        this.gatContext = gatContext;
        for (PreStagedFile file : this.files) {
            file.setGatContext(gatContext);
        }
    }
}

