/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.resources.cpi.PostStagedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StagedFile {
    protected static Logger logger = LoggerFactory.getLogger(StagedFile.class);
    protected GATContext gatContext;
    protected File origSrc;
    protected File origDest;
    private File resolvedSrc;
    private File resolvedDest;
    private String resolvedSrcURIString;
    private String resolvedDestURIString;
    protected String authority;
    protected String sandbox;
    protected boolean inSandbox;
    protected URI relativeURI;

    public StagedFile() {
    }

    public StagedFile(GATContext context, File origSrc, File origDest, String authority, String sandbox) {
        this.gatContext = context;
        this.origSrc = origSrc;
        this.origDest = origDest;
        this.authority = authority;
        this.sandbox = sandbox;
    }

    protected boolean inSandbox(String path) {
        try {
            return !path.startsWith("/") && !new java.net.URI(path).normalize().toString().startsWith("..");
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    protected File resolve(File f, boolean useNameOnly) throws GATInvocationException {
        URI origUri;
        URI uri = origUri = f.toGATURI();
        if (logger.isInfoEnabled()) {
            logger.info("resolving uri: " + uri);
        }
        if (uri.getAuthority() == null || useNameOnly) {
            try {
                uri = uri.setAuthority(this.authority);
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("StageFile", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("authority done: " + uri);
        }
        if (uri.getScheme() == null || useNameOnly) {
            try {
                uri = uri.setScheme("any");
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("StageFile", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("scheme done: " + uri);
        }
        if (useNameOnly) {
            if (f.isDirectory()) {
                try {
                    uri = uri.setPath("");
                }
                catch (URISyntaxException e) {
                    throw new GATInvocationException("StageFile", (Throwable)e);
                }
            }
            try {
                uri = uri.setPath(f.getName());
                if (logger.isInfoEnabled()) {
                    logger.info("local done: f.getName() = " + f.getName() + ", uri = " + uri);
                }
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("StageFile", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("path done: " + uri + "\npath: " + uri.getUnresolvedPath());
        }
        if (!uri.hasAbsolutePath()) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("setting path to :" + this.sandbox + "/" + uri.getUnresolvedPath());
                }
                uri = uri.setPath(this.sandbox + "/" + uri.getUnresolvedPath());
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("StageFile", (Throwable)e);
            }
        }
        try {
            this.relativeURI = new URI(f.getName());
        }
        catch (URISyntaxException e) {
            throw new GATInvocationException("StageFile", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("sandbox done: " + uri);
        }
        GATContext ctxt = f.getFileInterface().getGATContext();
        if (this instanceof PostStagedFile) {
            ctxt = (GATContext)ctxt.clone();
            ctxt.addPreference("file.copytime", (Object)"true");
        }
        try {
            return GAT.createFile((GATContext)ctxt, (URI)uri);
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("StageFile", (Throwable)e);
        }
    }

    protected void wipe(File f) throws GATInvocationException {
        if (!f.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("file to wipe does not exists, skipping.");
            }
            return;
        }
        if (!f.isFile()) {
            if (logger.isDebugEnabled()) {
                logger.debug("file to wipe is not a normal file, skipping.");
            }
            return;
        }
        long size = f.length();
        FileOutputStream out = null;
        try {
            out = GAT.createFileOutputStream((GATContext)this.gatContext, (File)f);
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("resource broker", (Throwable)e);
        }
        try {
            int toWipe;
            int bufSize = 65536;
            byte[] buf = new byte[bufSize];
            for (long wiped = 0L; wiped != size; wiped += (long)toWipe) {
                toWipe = size - wiped < (long)bufSize ? (int)(size - wiped) : bufSize;
                out.write(buf, 0, toWipe);
            }
        }
        catch (Exception e) {
            throw new GATInvocationException("resource broker", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean isInSandbox() {
        return this.inSandbox;
    }

    public void setInSandbox(boolean inSandbox) {
        this.inSandbox = inSandbox;
    }

    protected void setResolvedSrc(File resolvedSrc) {
        this.resolvedSrc = resolvedSrc;
        this.resolvedSrcURIString = resolvedSrc.toGATURI().toString();
    }

    public File getResolvedSrc() {
        if (this.resolvedSrc == null && this.resolvedSrcURIString != null) {
            try {
                this.resolvedSrc = GAT.createFile((GATContext)this.gatContext, (String)this.resolvedSrcURIString);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return this.resolvedSrc;
    }

    public String getResolvedDestURIString() {
        return this.resolvedDestURIString;
    }

    public void setResolvedDestURIString(String resolvedDestURIString) {
        this.resolvedDestURIString = resolvedDestURIString;
    }

    protected void setResolvedDest(File resolvedDest) {
        this.resolvedDest = resolvedDest;
        this.resolvedDestURIString = resolvedDest.toGATURI().toString();
    }

    public File getResolvedDest() {
        if (this.resolvedDest == null && this.resolvedDestURIString != null) {
            try {
                this.resolvedDest = GAT.createFile((GATContext)this.gatContext, (String)this.resolvedDestURIString);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return this.resolvedDest;
    }

    public String getResolvedSrcURIString() {
        return this.resolvedSrcURIString;
    }

    public void setResolvedSrcURIString(String resolvedSrcURIString) {
        this.resolvedSrcURIString = resolvedSrcURIString;
    }

    void setGatContext(GATContext gatContext) {
        this.gatContext = gatContext;
        this.resolvedDest = null;
        this.resolvedSrc = null;
    }
}

