/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.DataInfoProvider;
import integratedtoolkit.components.impl.TaskAnalyser;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.data.AccessParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.ResultFile;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.request.ap.APRequest;
import integratedtoolkit.types.request.ap.AlreadyAccessedRequest;
import integratedtoolkit.types.request.ap.DeleteFileRequest;
import integratedtoolkit.types.request.ap.EndOfAppRequest;
import integratedtoolkit.types.request.ap.GetLastRenamingRequest;
import integratedtoolkit.types.request.ap.GetResultFilesRequest;
import integratedtoolkit.types.request.ap.GraphDescriptionRequest;
import integratedtoolkit.types.request.ap.GraphUpdateRequest;
import integratedtoolkit.types.request.ap.IsObjectHereRequest;
import integratedtoolkit.types.request.ap.NewVersionSameValueRequest;
import integratedtoolkit.types.request.ap.RegisterDataAccessRequest;
import integratedtoolkit.types.request.ap.SetObjectVersionValueRequest;
import integratedtoolkit.types.request.ap.ShutdownRequest;
import integratedtoolkit.types.request.ap.TaskAnalysisRequest;
import integratedtoolkit.types.request.ap.TasksStateRequest;
import integratedtoolkit.types.request.ap.TransferObjectRequest;
import integratedtoolkit.types.request.ap.TransferOpenFileRequest;
import integratedtoolkit.types.request.ap.TransferRawFileRequest;
import integratedtoolkit.types.request.ap.UnblockResultFilesRequest;
import integratedtoolkit.types.request.ap.WaitForTaskRequest;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.Serializer;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class AccessProcessor
implements Runnable {
    protected static final String ERROR_OBJECT_DESERIALIZE = "ERROR: Cannot deserialize object from file";
    protected TaskDispatcher taskDispatcher;
    protected TaskAnalyser taskAnalyser;
    protected DataInfoProvider dataInfoProvider;
    private static Thread processor;
    private static boolean keepGoing;
    protected LinkedBlockingQueue<APRequest> requestQueue;
    private static final Logger logger;
    private static int CHANGES;
    int changes = CHANGES;

    public AccessProcessor() {
        this.taskAnalyser = new TaskAnalyser();
        this.dataInfoProvider = new DataInfoProvider();
        this.requestQueue = new LinkedBlockingQueue();
        keepGoing = true;
        processor = new Thread(this);
        processor.setName("Access Processor");
        processor.start();
    }

    public void setTD(TaskDispatcher TD) {
        this.taskDispatcher = TD;
        this.taskAnalyser.setCoWorkers(this.dataInfoProvider, TD);
        this.dataInfoProvider.setCoWorkers(TD);
    }

    @Override
    public void run() {
        while (keepGoing) {
            APRequest request = null;
            try {
                request = this.requestQueue.take();
                request.process(this.taskAnalyser, this.dataInfoProvider, this.taskDispatcher);
            }
            catch (InterruptedException e) {
                logger.error(e);
            }
            catch (ShutdownRequest.ShutdownException se) {
                break;
            }
            catch (Exception e) {
                logger.error(e);
                throw e;
            }
        }
        logger.info("AccessProcessor shutdown");
    }

    public int newTask(Long appId, String methodClass, String methodName, boolean priority, boolean hasTarget, Parameter[] parameters) {
        Task currentTask = new Task(appId, methodClass, methodName, priority, hasTarget, parameters);
        this.requestQueue.offer(new TaskAnalysisRequest(currentTask));
        return currentTask.getId();
    }

    public int newTask(Long appId, String namespace, String service, String port, String operation, boolean priority, boolean hasTarget, Parameter[] parameters) {
        Task currentTask = new Task(appId, namespace, service, port, operation, priority, hasTarget, parameters);
        this.requestQueue.offer(new TaskAnalysisRequest(currentTask));
        return currentTask.getId();
    }

    public void notifyTaskEnd(Task task, int implId, Worker<?> resource) {
        logger.info("Notification received for task " + task.getId() + " with end status " + (Object)((Object)task.getStatus()));
        this.requestQueue.offer(new GraphUpdateRequest(task, implId, resource));
    }

    public DataLocation mainAccessToFile(DataLocation sourceLocation, AccessParams.FileAccessParams fap, String destDir) {
        String rename;
        DataInstanceId daId;
        DataAccessId ra;
        boolean alreadyAccessed = this.alreadyAccessed(sourceLocation);
        if (!alreadyAccessed) {
            logger.debug("File not accessed before returning the same location");
            return sourceLocation;
        }
        DataAccessId faId = this.registerDataAccess(fap);
        DataLocation tgtLocation = sourceLocation;
        if (fap.getMode() != AccessParams.AccessMode.W) {
            logger.debug("File " + faId.getDataId() + " mode contains R, waiting until the last writer has finished");
            this.waitForTask(faId.getDataId(), AccessParams.AccessMode.R);
            if (destDir == null) {
                tgtLocation = this.transferFileOpen(faId);
            } else {
                if (fap.getMode() == AccessParams.AccessMode.R) {
                    ra = (DataAccessId.RAccessId)faId;
                    daId = ((DataAccessId.RAccessId)ra).getReadDataInstance();
                } else {
                    ra = (DataAccessId.RWAccessId)faId;
                    daId = ((DataAccessId.RWAccessId)ra).getReadDataInstance();
                }
                rename = daId.getRenaming();
                tgtLocation = DataLocation.getLocation(Comm.appHost, destDir + rename);
                this.transferFileRaw(faId, tgtLocation);
            }
        }
        if (fap.getMode() != AccessParams.AccessMode.R) {
            logger.debug("File " + faId.getDataId() + " mode contains W, register new writer");
            if (fap.getMode() == AccessParams.AccessMode.RW) {
                ra = (DataAccessId.RWAccessId)faId;
                daId = ((DataAccessId.RWAccessId)ra).getWrittenDataInstance();
            } else {
                ra = (DataAccessId.WAccessId)faId;
                daId = ((DataAccessId.WAccessId)ra).getWrittenDataInstance();
            }
            rename = daId.getRenaming();
            Comm.registerLocation(rename, tgtLocation);
        }
        logger.debug("File " + faId.getDataId() + " located on " + tgtLocation.toString());
        return tgtLocation;
    }

    public boolean isCurrentRegisterValueValid(int hashCode) {
        Semaphore sem = new Semaphore(0);
        IsObjectHereRequest request = new IsObjectHereRequest(hashCode, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return request.getResponse();
    }

    public Object mainAcessToObject(Object o, int hashCode, String destDir) {
        AccessParams.ObjectAccessParams oap = new AccessParams.ObjectAccessParams(AccessParams.AccessMode.RW, o, hashCode);
        DataAccessId oaId = this.registerDataAccess(oap);
        DataInstanceId rdId = ((DataAccessId.RWAccessId)oaId).getReadDataInstance();
        String rRename = rdId.getRenaming();
        DataInstanceId wId = ((DataAccessId.RWAccessId)oaId).getWrittenDataInstance();
        String wRename = wId.getRenaming();
        this.waitForTask(oaId.getDataId(), AccessParams.AccessMode.RW);
        logger.debug("Task creator of object with hash code " + hashCode + " is finished");
        Object oUpdated = this.obtainObject(oaId);
        if (oUpdated == null) {
            try {
                oUpdated = Serializer.deserialize(destDir + rRename);
            }
            catch (Exception e) {
                logger.fatal("ERROR: Cannot deserialize object from file: " + destDir + rRename, e);
                System.exit(1);
            }
        }
        this.setObjectVersionValue(wRename, oUpdated);
        return oUpdated;
    }

    public void noMoreTasks(Long appId) {
        Semaphore sem = new Semaphore(0);
        this.requestQueue.offer(new EndOfAppRequest(appId, sem));
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("All tasks finished");
    }

    private boolean alreadyAccessed(DataLocation loc) {
        Semaphore sem = new Semaphore(0);
        AlreadyAccessedRequest request = new AlreadyAccessedRequest(loc, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return request.getResponse();
    }

    private void waitForTask(int dataId, AccessParams.AccessMode mode) {
        Semaphore sem = new Semaphore(0);
        this.requestQueue.offer(new WaitForTaskRequest(dataId, mode, sem));
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        logger.info("End of waited task for data " + dataId);
    }

    private DataAccessId registerDataAccess(AccessParams access) {
        Semaphore sem = new Semaphore(0);
        RegisterDataAccessRequest request = new RegisterDataAccessRequest(access, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return request.getResponse();
    }

    public void newVersionSameValue(String rRenaming, String wRenaming) {
        NewVersionSameValueRequest request = new NewVersionSameValueRequest(rRenaming, wRenaming);
        this.requestQueue.offer(request);
    }

    public void setObjectVersionValue(String renaming, Object value) {
        SetObjectVersionValueRequest request = new SetObjectVersionValueRequest(renaming, value);
        this.requestQueue.offer(request);
    }

    public String getLastRenaming(int code) {
        Semaphore sem = new Semaphore(0);
        GetLastRenamingRequest request = new GetLastRenamingRequest(code, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return request.getResponse();
    }

    public void unblockResultFiles(List<ResultFile> resFiles) {
        UnblockResultFilesRequest request = new UnblockResultFilesRequest(resFiles);
        this.requestQueue.offer(request);
    }

    public void shutdown() {
        Semaphore sem = new Semaphore(0);
        this.requestQueue.offer(new ShutdownRequest(sem));
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getCurrentGraphState() {
        Semaphore sem = new Semaphore(0);
        GraphDescriptionRequest request = new GraphDescriptionRequest(sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return request.getResponse();
    }

    public String getCurrentTaskState() {
        Semaphore sem = new Semaphore(0);
        TasksStateRequest request = new TasksStateRequest(sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return request.getResponse();
    }

    public void markForDeletion(DataLocation loc) {
        this.requestQueue.offer(new DeleteFileRequest(loc));
    }

    private void transferFileRaw(DataAccessId faId, DataLocation location) {
        Semaphore sem = new Semaphore(0);
        TransferRawFileRequest request = new TransferRawFileRequest((DataAccessId.RAccessId)faId, location, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        logger.debug("Raw file transferred");
    }

    private DataLocation transferFileOpen(DataAccessId faId) {
        Semaphore sem = new Semaphore(0);
        TransferOpenFileRequest request = new TransferOpenFileRequest(faId, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        logger.debug("Open file transferred");
        return request.getLocation();
    }

    private Object obtainObject(DataAccessId oaId) {
        Semaphore sem = new Semaphore(0);
        TransferObjectRequest tor = new TransferObjectRequest(oaId, sem);
        this.requestQueue.offer(tor);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return tor.getResponse();
    }

    public void getResultFiles(Long appId) {
        Semaphore sem = new Semaphore(0);
        GetResultFilesRequest request = new GetResultFilesRequest(appId, sem);
        this.requestQueue.offer(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        UnblockResultFilesRequest urfr = new UnblockResultFilesRequest(request.getBlockedData());
        this.requestQueue.offer(urfr);
    }

    static {
        logger = Logger.getLogger("integratedtoolkit.Components.TaskProcessor");
        CHANGES = 1;
    }
}

