/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader;

import java.util.LinkedList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.apache.log4j.Logger;

public class AddOrchestration {
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            logger.fatal("Error: missing arguments for loader");
            System.exit(1);
        }
        String className = args[0];
        String classPackage = AddOrchestration.getPackage(className);
        ClassPool pool = ClassPool.getDefault();
        if (classPackage != null && classPackage.trim().length() > 0) {
            pool.importPackage(classPackage);
        }
        CtClass cc = pool.getCtClass(className);
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        for (int i = 1; i < args.length; ++i) {
            CtClass[] params;
            String methodLabel = args[i];
            String methodName = AddOrchestration.getMethodName(methodLabel);
            CtMethod methodDescriptor = cc.getDeclaredMethod(methodName, params = AddOrchestration.getParamClasses(methodLabel, pool));
            AnnotationsAttribute attr = (AnnotationsAttribute)methodDescriptor.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            if (attr == null) {
                attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            }
            Annotation annot = new Annotation("integratedtoolkit.types.annotations.Orchestration", constpool);
            attr.addAnnotation(annot);
            methodDescriptor.getMethodInfo().addAttribute(attr);
        }
        cc.writeFile();
    }

    private static CtClass[] getParamClasses(String label, ClassPool pool) throws NotFoundException, Exception {
        LinkedList<CtClass> classes = new LinkedList<CtClass>();
        List<String> params = AddOrchestration.getParametersTypeFromLabel(label);
        if (params != null && params.size() > 0) {
            for (String className : params) {
                String pack = AddOrchestration.getPackage(className);
                if (pack != null) {
                    pool.importPackage(pack);
                }
                classes.add(pool.getCtClass(className));
            }
            return classes.toArray(new CtClass[classes.size()]);
        }
        return new CtClass[0];
    }

    public static List<String> getParametersTypeFromLabel(String label) throws Exception {
        int begin = label.indexOf("(");
        int end = label.indexOf(")");
        if (begin > 0 && end > 0 && end > begin) {
            String[] parametersArray;
            String parsString = label.substring(begin + 1, end);
            if (logger.isDebugEnabled()) {
                logger.debug("Parameters: " + parsString);
            }
            LinkedList<String> parameters = new LinkedList<String>();
            if (parsString != null && parsString.trim().length() > 0 && (parametersArray = parsString.split(", ")) != null && parametersArray.length > 0) {
                for (String parameter : parametersArray) {
                    parameters.add(parameter);
                }
            }
            return parameters;
        }
        throw new Exception("Error incorrect label " + label);
    }

    private static String getMethodName(String label) throws Exception {
        int i = label.indexOf("(");
        if (i > 0) {
            return label.substring(0, i);
        }
        throw new Exception("Error method name from label " + label);
    }

    private static String getPackage(String className) throws Exception {
        if (className != null && className.trim().length() > 0) {
            int i = className.lastIndexOf(".");
            if (i >= 0) {
                return className.substring(i + 1).trim();
            }
            return null;
        }
        throw new Exception("ClassName is null");
    }
}

