/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.operation;

import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.Worker;
import org.apache.log4j.Logger;

public class JobTransfersListener
extends DataOperation.EventListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.FileTransferManager");
    private static final boolean debug = logger.isDebugEnabled();
    private Job<?> job;
    private Worker<?> res;
    private JobManager JM;

    public JobTransfersListener(Job<?> job, Worker<?> res, JobManager jm) {
        this.job = job;
        this.res = res;
        this.JM = jm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(DataOperation fOp) {
        boolean enabled;
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        boolean enabled;
        boolean finished;
        e.printStackTrace();
        if (debug) {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is JOB_FILE" + ", operation end state is FAILED", e);
        } else {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is JOB_FILE" + ", operation end state is FAILED");
        }
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.JM.submitJob(this.job, this.res);
    }

    private void doFailures() {
        this.JM.failedTransfers(this.job, this.errors, this.res);
    }
}

