/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.commands.Data;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;

public class NIOParam
implements Externalizable {
    private ITExecution.ParamType type;
    private boolean mustWrite;
    private Data data;
    private Object value;

    public NIOParam() {
    }

    public NIOParam(ITExecution.ParamType type, Object value, boolean mustWrite, Data data) {
        this.type = type;
        this.value = value;
        this.mustWrite = mustWrite;
        this.data = data;
    }

    public ITExecution.ParamType getType() {
        return this.type;
    }

    public boolean isWrite() {
        return this.mustWrite;
    }

    public Object getValue() {
        return this.value;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (ITExecution.ParamType)((Object)in.readObject());
        this.value = in.readObject();
        this.mustWrite = in.readBoolean();
        try {
            this.data = (Data)in.readObject();
        }
        catch (OptionalDataException e) {
            this.data = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeObject(this.value);
        out.writeBoolean(this.mustWrite);
        if (this.data != null) {
            out.writeObject(this.data);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PARAM");
        sb.append("[TYPE = ").append((Object)this.type).append("]");
        sb.append("[DATA ").append(this.data).append("]");
        sb.append("[VALUE = ").append(this.value).append("]");
        sb.append("[STORE AT END = ").append(this.mustWrite).append("]");
        sb.append("]");
        return sb.toString();
    }
}

