/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.transfers.Transfer;
import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.NIOMessageHandler;
import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.nio.commands.CommandDataReceived;
import integratedtoolkit.nio.commands.CommandShutdownACK;
import integratedtoolkit.nio.commands.CommandTaskDone;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.worker.JobLauncher;
import integratedtoolkit.nio.worker.ObjectCache;
import integratedtoolkit.nio.worker.ThreadPrintStream;
import integratedtoolkit.util.RequestQueue;
import integratedtoolkit.util.Serializer;
import integratedtoolkit.util.ThreadPool;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.LinkedList;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class NIOWorker
extends NIOAgent {
    public static boolean workerDebug;
    public static String workingDir;
    public static int jobThreads;
    public static String POOL_NAME;
    protected static final String THREAD_POOL_ERR = "Error starting pool of threads";
    protected static final Logger wLogger;
    protected static ThreadPool pool;
    public static RequestQueue<NIOTask> jobQueue;
    public static ThreadPrintStream out;
    public static ThreadPrintStream err;
    private final ObjectCache objectCache;
    private final String host;
    private String deploymentId;

    public NIOWorker(String uuid, int snd, int rcv, int masterPort, String hostName) {
        super(snd, rcv, masterPort);
        this.deploymentId = uuid;
        this.objectCache = new ObjectCache();
        this.masterNode = null;
        jobQueue = new RequestQueue();
        pool = new ThreadPool(jobThreads, POOL_NAME, new JobLauncher(jobQueue, this, wLogger, workerDebug));
        try {
            pool.startThreads();
        }
        catch (Exception e) {
            wLogger.error(THREAD_POOL_ERR, e);
            System.exit(1);
        }
        this.host = hostName;
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
    }

    @Override
    public void setMaster(NIONode master) {
        if (this.masterNode == null) {
            this.masterNode = new NIONode(master.ip, masterPort);
        }
    }

    @Override
    public boolean isMyUuid(String uuid) {
        return uuid.equals(this.deploymentId);
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask task, LinkedList<String> obsoleteFiles) {
        wLogger.info("Received Job " + task);
        if (obsoleteFiles != null) {
            this.removeObsolete(obsoleteFiles);
        }
        TransferringTask tt = new TransferringTask(task);
        int i = 0;
        for (NIOParam param : task.getParams()) {
            ++i;
            if (param.getData() != null) {
                wLogger.debug("A copy has been ordered for " + (String)param.getValue() + ". Checking if transfer is needed.");
                boolean exists = false;
                if (param.getType() == ITExecution.ParamType.OBJECT_T) {
                    wLogger.debug("- " + (String)param.getValue() + " registered as object.");
                    wLogger.debug("Checking if " + (String)param.getValue() + " is in cache.");
                    exists = this.objectCache.checkPresence((String)param.getValue());
                } else {
                    wLogger.debug("- " + (String)param.getValue() + " registered as file.");
                    wLogger.debug("Checking if file " + (String)param.getValue() + " exists.");
                    File f = new File((String)param.getValue());
                    exists = f.exists();
                }
                if (!exists) {
                    wLogger.debug("Checking if " + (String)param.getValue() + " exists in worker");
                    NIOURI loc = param.getData().getURIinHost(this.host);
                    if (loc != null) {
                        wLogger.debug("\tParameter " + i + "(" + (String)param.getValue() + ") found. Performing local copy.");
                        try {
                            Files.copy(new File(loc.getPath()).toPath(), new File((String)param.getValue()).toPath(), new CopyOption[0]);
                            exists = true;
                            if (param.getType() == ITExecution.ParamType.OBJECT_T) {
                                try {
                                    Object o = Serializer.deserialize((String)param.getValue());
                                    this.storeInCache((String)param.getValue(), o);
                                }
                                catch (ClassNotFoundException e) {
                                    wLogger.error(e);
                                    this.sendTaskDone(task, false);
                                }
                            }
                        }
                        catch (IOException ioe) {
                            wLogger.error(ioe);
                            this.sendTaskDone(task, false);
                        }
                    }
                }
                if (!exists) {
                    wLogger.info("\tParameter " + i + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
                    WorkerDataRequest dr = new WorkerDataRequest(tt, param.getType(), param.getData(), (String)param.getValue());
                    this.addTransferRequest(dr);
                    continue;
                }
                wLogger.info("\tParameter " + i + "(" + (String)param.getValue() + ") already exists.");
            }
            --tt.params;
        }
        if (tracing) {
            NIOTracer.emitEvent("start", String.valueOf(Tracer.Event.TRANSFER.getSlot()), String.valueOf(tt.task.getTaskId()), String.valueOf(Tracer.Event.TRANSFER.getType()));
        }
        this.requestTransfers();
        if (tracing) {
            NIOTracer.endTask(String.valueOf(Tracer.Event.TRANSFER.getSlot()), String.valueOf(Tracer.Event.TRANSFER.getType()));
        }
        if (tt.params == 0) {
            this.executeTask(tt.task);
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, LinkedList<NIOAgent.DataRequest> achievedRequests) {
        wLogger.info("Received data " + dataId);
        if (type == Transfer.Destination.OBJECT) {
            this.storeInCache(dataId, object);
        }
        for (NIOAgent.DataRequest dr : achievedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            --((WorkerDataRequest)wdr).task.params;
            if (((WorkerDataRequest)wdr).task.params != 0) continue;
            this.executeTask(((WorkerDataRequest)wdr).task.task);
        }
    }

    public void sendTaskDone(NIOTask nt, boolean successful) {
        int taskID = nt.getJobId();
        Connection c = TransferManager.startConnection(this.masterNode);
        CommandTaskDone cmd = new CommandTaskDone(this, taskID, successful);
        c.sendCommand(cmd);
        if (workerDebug) {
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".out");
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".err");
        } else if (!successful) {
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".err");
        }
        c.finishConnection();
    }

    private void executeTask(NIOTask task) {
        if (workerDebug) {
            wLogger.debug("Enqueueing job " + task.getJobId() + " for execution.");
        }
        jobQueue.enqueue(task);
        if (workerDebug) {
            wLogger.debug("Notifying presence of all data for job " + task.getJobId() + ".");
        }
        CommandDataReceived cdr = new CommandDataReceived(this, task.getTransferGroupId());
        Connection c = TransferManager.startConnection(this.masterNode);
        c.sendCommand(cdr);
        c.finishConnection();
    }

    public void removeObsolete(LinkedList<String> obsolete) {
        try {
            for (String name : obsolete) {
                if (name.startsWith(File.separator)) {
                    File f = new File(name);
                    f.delete();
                    continue;
                }
                this.removeFromCache(name);
            }
        }
        catch (Exception e) {
            wLogger.error(e);
        }
    }

    public void receivedUpdateSources(Connection c) {
    }

    @Override
    public void shutdown(Connection closingConnection) {
        try {
            pool.stopThreads();
            closingConnection.sendCommand(new CommandShutdownACK());
            closingConnection.finishConnection();
            TransferManager.shutdown(closingConnection);
        }
        catch (Exception e) {
            wLogger.error(e);
        }
    }

    @Override
    public Object getObject(String s) {
        String realName = s.substring(s.lastIndexOf(47) + 1);
        return this.objectCache.get(realName);
    }

    public void storeInCache(String name, Object value) {
        this.objectCache.store(name, value);
    }

    public void removeFromCache(String name) {
        this.objectCache.remove(name);
    }

    @Override
    public String getWorkingDir() {
        return workingDir + "/";
    }

    public static void main(String[] args) {
        workerDebug = new Boolean(args[0]);
        workingDir = args[1];
        jobThreads = new Integer(args[2]);
        int maxSnd = new Integer(args[3]);
        int maxRcv = new Integer(args[4]);
        String workerIP = args[5];
        int wPort = new Integer(args[6]);
        int mPort = new Integer(args[7]);
        String trace = args[8];
        String host = args[9];
        String installDir = args[10];
        String appUuid = args[11];
        System.setProperty("it.tracing", trace);
        tracing = Boolean.parseBoolean(trace);
        ConsoleAppender console = new ConsoleAppender();
        Logger.getRootLogger().setLevel(workerDebug ? Level.DEBUG : Level.OFF);
        String PATTERN = "%d [%p|%c|%C{1}] %m%n";
        console.setLayout(new PatternLayout(PATTERN));
        console.activateOptions();
        Logger.getRootLogger().addAppender(console);
        if (workerDebug) {
            wLogger.debug("WorkingDir:" + workingDir);
            wLogger.debug("jobThreads: " + String.valueOf(jobThreads));
            wLogger.debug("maxSnd: " + String.valueOf(maxSnd));
            wLogger.debug("maxRcv: " + String.valueOf(maxRcv));
            wLogger.debug("WorkerName: " + workerIP);
            wLogger.debug("WorkerPort: " + String.valueOf(wPort));
            wLogger.debug("MasterPort: " + String.valueOf(mPort));
            wLogger.debug("Tracing: " + trace);
            wLogger.debug("Host: " + host);
            wLogger.debug("Install Dir: " + installDir);
            wLogger.debug("App uuid: " + appUuid);
        }
        NIOWorker nw = new NIOWorker(appUuid, maxSnd, maxRcv, mPort, workerIP);
        NIOMessageHandler mh = new NIOMessageHandler(nw, new NIONode(null, wPort));
        NIOTracer.setWorkerInfo(installDir, workerIP, workingDir);
        TransferManager.init("NIO", null, mh);
    }

    public static void registerOutputs(String path) {
        err.registerThread(path);
        out.registerThread(path);
    }

    public static void unregisterOutputs() {
        err.unregisterThread();
        out.unregisterThread();
    }

    @Override
    public void receivedTaskDone(Connection c, int jobID, boolean successful) {
    }

    @Override
    public void copiedData(int transfergroupID) {
    }

    @Override
    public void shutdownNotification(Connection c) {
    }

    public String getHostName() {
        return this.host;
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
    }

    @Override
    public void notifyTracingPackageGeneration() {
    }

    static {
        POOL_NAME = "NIO_JOBS";
        wLogger = Logger.getLogger("integratedtoolkit.Worker");
        try {
            out = new ThreadPrintStream(".out", System.out);
            err = new ThreadPrintStream(".err", System.err);
            System.setErr(err);
            System.setOut(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class TransferringTask {
        NIOTask task;
        int params;

        public TransferringTask(NIOTask task) {
            this.task = task;
            this.params = task.getParams().size();
        }
    }

    private class WorkerDataRequest
    extends NIOAgent.DataRequest {
        private final TransferringTask task;

        public WorkerDataRequest(TransferringTask task, ITExecution.ParamType type, Data source, String target) {
            super(type, source, target);
            this.task = task;
        }
    }
}

