/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data;

import java.io.Serializable;

public class DataInstanceId
implements Serializable,
Comparable<DataInstanceId> {
    private static String timeStamp = Long.toString(System.currentTimeMillis());
    private int dataId;
    private int versionId;
    private String renaming;

    public DataInstanceId() {
    }

    public DataInstanceId(int dataId, int versionId) {
        this.dataId = dataId;
        this.versionId = versionId;
        this.renaming = "d" + dataId + "v" + versionId + "_" + timeStamp + ".IT";
    }

    public int getDataId() {
        return this.dataId;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public String getRenaming() {
        return this.renaming;
    }

    public String toString() {
        return "d" + this.dataId + "v" + this.versionId;
    }

    @Override
    public int compareTo(DataInstanceId dId) {
        if (dId == null) {
            throw new NullPointerException();
        }
        if (dId.dataId != this.dataId) {
            return dId.dataId - this.dataId;
        }
        return dId.versionId - this.versionId;
    }

    public boolean equals(Object o) {
        return o instanceof DataInstanceId && this.compareTo((DataInstanceId)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static String previousVersionRenaming(String renaming) {
        int dIdx = renaming.indexOf(100);
        int vIdx = renaming.indexOf(118);
        int tIndex = renaming.indexOf(95);
        if (vIdx == 1) {
            return null;
        }
        int dataId = Integer.parseInt(renaming.substring(dIdx + 1, vIdx));
        int previousVersion = Integer.parseInt(renaming.substring(vIdx + 1, tIndex)) - 1;
        return "d" + dataId + "v" + previousVersion + "_" + timeStamp + ".IT";
    }
}

