/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.operation;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.resources.Resource;
import java.util.List;

public abstract class Copy
extends DataOperation {
    protected final LogicalData srcData;
    protected final DataLocation srcLoc;
    protected final LogicalData tgtData;
    protected DataLocation tgtLoc;
    protected final Transferable reason;

    public Copy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        super(srcData, listener);
        this.srcData = srcData;
        this.srcLoc = prefSrc;
        this.tgtData = tgtData;
        this.tgtLoc = prefTgt;
        this.reason = reason;
    }

    public LogicalData getSourceData() {
        return this.srcData;
    }

    public DataLocation getPreferredSource() {
        return this.srcLoc;
    }

    public DataLocation getTargetLoc() {
        return this.tgtLoc;
    }

    public LogicalData getTargetData() {
        return this.tgtData;
    }

    public boolean isRegistered() {
        return this.tgtData != null;
    }

    public void setProposedSource(Object source) {
        this.reason.setDataSource(source);
    }

    public void setFinalTarget(String targetAbsolutePath) {
        this.reason.setDataTarget(targetAbsolutePath);
    }

    public String getFinalTarget() {
        return this.reason.getDataTarget();
    }

    public ITExecution.ParamType getType() {
        return this.reason.getType();
    }

    public static abstract class ImmediateCopy
    extends Copy {
        public ImmediateCopy(LogicalData ld, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
            super(ld, prefSrc, prefTgt, tgtData, reason, listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform() {
            Resource targetHost = this.tgtLoc.getHosts().getFirst();
            logger.debug("THREAD " + Thread.currentThread().getName() + " - Copy file " + this.getName() + " to " + this.tgtLoc);
            LogicalData logicalData = this.srcData;
            synchronized (logicalData) {
                if (this.tgtData != null) {
                    URI u = this.srcData.alreadyAvailable(targetHost);
                    if (u != null) {
                        this.setFinalTarget(u.getPath());
                        this.end(DataOperation.OpEndState.OP_OK);
                        logger.debug("THREAD " + Thread.currentThread().getName() + " - A copy of " + this.getName() + " is already present at " + targetHost + " on path " + u.getPath());
                        return;
                    }
                    Copy copyInProgress = null;
                    copyInProgress = this.srcData.alreadyCopying(this.tgtLoc);
                    if (copyInProgress != null) {
                        String path = copyInProgress.tgtLoc.getURIInHost(targetHost).getPath();
                        this.setFinalTarget(path);
                        this.end(DataOperation.OpEndState.OP_IN_PROGRESS);
                        List<DataOperation.EventListener> list = copyInProgress.getEventListeners();
                        synchronized (list) {
                            copyInProgress.addEventListeners(this.getEventListeners());
                        }
                        logger.debug("THREAD " + Thread.currentThread().getName() + " - A copy to " + path + " is already in progress, skipping replication");
                        return;
                    }
                }
                this.srcData.startCopy(this, this.tgtLoc);
            }
            try {
                this.specificCopy();
            }
            catch (Exception e) {
                this.end(DataOperation.OpEndState.OP_FAILED, e);
                return;
            }
            finally {
                DataLocation actualLocation;
                LogicalData logicalData2 = this.srcData;
                synchronized (logicalData2) {
                    actualLocation = this.srcData.finishedCopy(this);
                }
                if (this.tgtData != null) {
                    logicalData2 = this.tgtData;
                    synchronized (logicalData2) {
                        this.tgtData.addLocation(actualLocation);
                    }
                }
            }
            String path = this.tgtLoc.getURIInHost(targetHost).getPath();
            this.setFinalTarget(path);
            LogicalData logicalData3 = this.srcData;
            synchronized (logicalData3) {
                this.end(DataOperation.OpEndState.OP_OK);
            }
        }

        public abstract void specificCopy() throws Exception;
    }

    public static class DeferredCopy
    extends Copy {
        public DeferredCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
            super(srcData, prefSrc, prefTgt, tgtData, reason, listener);
        }
    }
}

