/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import es.bsc.cepbatools.extrae.Wrapper;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.TracingCopyListener;
import integratedtoolkit.types.data.operation.TracingCopyTransferable;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class Tracer {
    public static final int DEFAULT_NUM_THREADS = 16;
    private static final String taskDesc = "Task";
    private static final String apiDesc = "Runtime";
    private static final String taskIdDesc = "Task IDs";
    private static final String transferDesc = "Transfers";
    protected static final String TRACE_SCRIPT = "trace.sh";
    protected static final String traceOutRelativePath = "/trace/tracer.out";
    protected static final String traceErrRelativePath = "/trace/tracer.err";
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.JobManager");
    protected static final boolean debug = logger.isDebugEnabled();
    protected static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    protected static final int EVENTS_TYPE = 8000000;
    protected static final int API_TYPE = 8000001;
    protected static final int TASK_SCHEDULING_TYPE = 8000002;
    protected static final int TRANSFERS_TYPE = 8000003;
    private static final int UNKNOWN_SLOT = -88;
    private static String traceDirPath;
    private static Map<String, TraceHost> hostToSlots;
    private static AtomicInteger hostId;

    public static void init() {
        hostId = new AtomicInteger(1);
        if (debug) {
            logger.debug("Initializing tracing");
        }
        if (!new File(traceDirPath = Comm.appHost.getAppLogDirPath() + "trace" + File.separator).mkdir()) {
            System.err.println(ERROR_TRACE_DIR);
            System.exit(1);
        }
        Wrapper.SetTaskID(0);
        Wrapper.SetNumTasks(1);
        Wrapper.Init();
        hostToSlots = new Hashtable<String, TraceHost>();
    }

    public static String getTraceDirPath() {
        return traceDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (debug) {
            logger.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (debug) {
                    logger.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = hostId.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = hostToSlots.get(host).getNextSlot();
        if (debug) {
            logger.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (debug) {
            logger.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        hostToSlots.get(host).freeSlot(slot);
    }

    public static int getEventsType() {
        return 8000000;
    }

    public static int getTaskSchedulingType() {
        return 8000002;
    }

    public static void staticEventStart(int taskId) {
        Wrapper.Event(8000001, taskId);
    }

    public static void staticEventStop() {
        Wrapper.Event(8000001, 0L);
    }

    public static void masterEventStart(int taskId) {
        Wrapper.Event(8000001, taskId);
    }

    public static void masterEventFinish() {
        Wrapper.Event(8000001, 0L);
    }

    public static int getFixedOffset() {
        return Event.values().length;
    }

    public static int getOffsetForIdEmit() {
        int offset = Event.values().length + CoreManager.SIGNATURE_TO_ID.size();
        if (debug) {
            logger.debug("Offset = " + Event.values().length + " + " + CoreManager.SIGNATURE_TO_ID.size());
        }
        return offset;
    }

    public static void fini() {
        if (debug) {
            logger.debug("Tracing: finalizing");
        }
        Tracer.defineEvents();
        Wrapper.Fini();
        Tracer.generateMasterPackage();
        Tracer.transferMasterPackage();
        Tracer.generateTrace();
        Tracer.cleanMasterPackage();
    }

    private static void defineEvents() {
        if (debug) {
            logger.debug("SignatureToId size: " + CoreManager.SIGNATURE_TO_ID.size());
        }
        Tracer.defineTaskIdEvents(CoreManager.SIGNATURE_TO_ID);
    }

    private static void defineTaskIdEvents(Map<String, Integer> signatureToId) {
        if (debug) {
            logger.debug("Tracing: Defining Task-with-ID Events");
        }
        int size = Event.values().length + 1;
        long[] values = new long[size];
        int offset = Event.values().length;
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Event task : Event.values()) {
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (debug) {
                logger.debug("Tracing[API]: Api Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000001, apiDesc, values, descriptionValues);
        size = signatureToId.entrySet().size() + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Map.Entry<String, Integer> entry : signatureToId.entrySet()) {
            String methodName;
            String signature = entry.getKey();
            Integer methodId = entry.getValue();
            values[i] = methodId + 1 + offset;
            descriptionValues[i] = methodName = signature.substring(0, signature.indexOf(40));
            if (debug) {
                logger.debug("Tracing[ID]: Task Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000000, taskDesc, values, descriptionValues);
        size = 0;
        values = new long[size];
        descriptionValues = new String[size];
        Wrapper.defineEventType(8000002, taskIdDesc, values, descriptionValues);
        Wrapper.defineEventType(8000003, transferDesc, values, descriptionValues);
    }

    public static void generateMasterPackage() {
        if (debug) {
            logger.debug("Tracing: generating master package");
        }
        String scriptDir = System.getProperty("it.script.dir");
        ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + TRACE_SCRIPT, "package", ".", "master");
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            logger.error("Error generating master package", e);
            return;
        }
        if (debug) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                logger.error("Error generating master package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error generating master package (interruptedException) : " + e.getMessage());
        }
    }

    public static void transferMasterPackage() {
        if (debug) {
            logger.debug("Tracing: Transferring master package");
        }
        Semaphore sem = new Semaphore(0);
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        String filename = "master_compss_trace.tar.gz";
        DataLocation source = DataLocation.getLocation(Comm.appHost, filename);
        DataLocation target = DataLocation.getLocation(Comm.appHost, traceDirPath + filename);
        COMPSsNode node = Comm.appHost.getNode();
        tracingListener.addOperation();
        node.obtainData(new LogicalData("tracing master package"), source, target, new LogicalData("tracing master package"), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            logger.error("Error waiting for tracing files in master to get saved");
        }
    }

    public static void generateTrace() {
        if (debug) {
            logger.debug("Tracing: Generating trace");
        }
        String scriptDir = System.getProperty("it.script.dir");
        String appName = System.getProperty("it.appName");
        ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + TRACE_SCRIPT, "gentrace", System.getProperty("it.appLogDir"), appName);
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            logger.error("Error generating trace", e);
            return;
        }
        if (debug) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                logger.error("Error generating trace, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error generating trace (interruptedException) : " + e.getMessage());
        }
    }

    public static void cleanMasterPackage() {
        String filename = "master_compss_trace.tar.gz";
        DataLocation source = DataLocation.getLocation(Comm.appHost, filename);
        if (debug) {
            logger.debug("Tracing: Removing tracing master package: " + source.getPath());
        }
        File f = null;
        try {
            f = new File(source.getPath());
            f.delete();
        }
        catch (Exception e) {
            logger.error("Unable to remove tracing temporary files of master node.");
        }
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        public TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        public int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        public void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }

    public static enum Event {
        STATIC_IT(1, 8000001, "Loading Runtime"),
        START_IT(2, 8000001, "Start"),
        STOP_IT(3, 8000001, "Stop"),
        TASK(4, 8000001, "Execute Task"),
        NO_MORE_TASKS(5, 8000001, "Waiting for tasks end"),
        OPEN_FILE(6, 8000001, "Waiting for open file"),
        GET_FILE(7, 8000001, "Waiting for get file"),
        GET_OBJECT(8, 8000001, "Waiting for get object"),
        DELETE_FILE(9, 8000001, "Delete File"),
        TASK_RUNNING(10, 8000001, "Task Running"),
        TRANSFER(11, 8000003, 0, "Transferring files (requestTransfers method)");

        private final int id;
        private final int slot;
        private final int type;
        private final String signature;

        private Event(int id, int type, String signature) {
            this.id = id;
            this.slot = -88;
            this.type = type;
            this.signature = signature;
        }

        private Event(int id, int type, int slot, String signature) {
            this.id = id;
            this.type = type;
            this.slot = slot;
            this.signature = signature;
        }

        public int getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public int getSlot() {
            if (this.slot == -88) {
                logger.error("This event has not an associated slot");
            }
            return this.slot;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

