/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.gat.master.GATWorkerNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.parameter.BasicTypeParameter;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.HardwareResourceDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class GATJob
extends integratedtoolkit.types.job.Job<GATWorkerNode>
implements MetricListener {
    private static final String JOBS_DIR = System.getProperty("it.appLogDir") + "jobs" + File.separator;
    private static final String CALLBACK_PROCESSING_ERR = "Error processing callback for job";
    private static final String ANY_PROT = "any://";
    private static final String JOB_STATUS = "job.status";
    private static final String RES_ATTR = "machine.node";
    private static final String TERM_ERR = "Error terminating";
    private Job GATjob;
    private static GATContext context;
    private static boolean usingGlobus;
    private static boolean userNeeded;
    private static Map<String, ResourceBroker> brokers;
    private static final String workerClasspath;
    private static final String WORKER_SCRIPT = "adaptors/gat/worker.sh";
    public static LinkedList<GATJob> runningJobs;

    public static void init() {
        if (context == null) {
            context = new GATContext();
            String brokerAdaptor = System.getProperty("it.gat.broker.adaptor");
            String fileAdaptor = System.getProperty("it.gat.file.adaptor");
            context.addPreference("ResourceBroker.adaptor.name", brokerAdaptor);
            context.addPreference("File.adaptor.name", fileAdaptor + ", local");
            usingGlobus = brokerAdaptor.equalsIgnoreCase("globus");
            userNeeded = brokerAdaptor.regionMatches(true, 0, "ssh", 0, 3);
        }
        brokers = new TreeMap<String, ResourceBroker>();
    }

    public static void addAdaptorPreference(String property, String value) {
        context.addPreference(property, value);
    }

    public GATJob(Task task, Implementation<?> impl, Resource res, Job.JobListener listener) {
        super(task, impl, res, listener);
    }

    @Override
    public Job.JobKind getKind() {
        return Job.JobKind.METHOD;
    }

    @Override
    public void submit() throws Exception {
        logger.info("Submit GTJob with ID " + this.jobId);
        JobDescription jobDescr = null;
        jobDescr = this.prepareJob();
        ResourceBroker broker = null;
        String dest = (String)jobDescr.getResourceDescription().getResourceAttribute(RES_ATTR);
        broker = brokers.get(dest);
        if (broker == null) {
            broker = GAT.createResourceBroker(context, new URI(dest));
            brokers.put(dest, broker);
        }
        Job job = null;
        try {
            job = broker.submitJob(jobDescr, this, JOB_STATUS);
            runningJobs.add(this);
        }
        catch (Exception e) {
            if (tracing) {
                Tracer.freeSlot(((GATWorkerNode)this.worker.getNode()).getHost(), (Integer)jobDescr.getSoftwareDescription().getAttributes().get("slot"));
            }
            throw e;
        }
        this.GATjob = job;
    }

    protected static void stopAll() {
        for (GATJob job : runningJobs) {
            try {
                job.stop();
            }
            catch (Exception e) {
                logger.error(TERM_ERR, e);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.GATjob != null) {
            MetricDefinition md = this.GATjob.getMetricDefinitionByName(JOB_STATUS);
            Metric m = md.createMetric();
            this.GATjob.removeMetricListener(this, m);
            this.GATjob.stop();
        }
    }

    @Override
    public void processMetricEvent(MetricEvent value) {
        block16: {
            Job job = (Job)value.getSource();
            Job.JobState newJobState = (Job.JobState)((Object)value.getValue());
            JobDescription jd = (JobDescription)job.getJobDescription();
            SoftwareDescription sd = jd.getSoftwareDescription();
            Integer jobId = (Integer)sd.getAttributes().get("jobId");
            logger.debug("Processing job ID = " + jobId);
            if (newJobState == Job.JobState.STOPPED) {
                if (tracing) {
                    Integer slot = (Integer)sd.getAttributes().get("slot");
                    Tracer.freeSlot(((GATWorkerNode)this.getResourceNode()).getHost(), slot);
                }
                try {
                    if (usingGlobus) {
                        org.gridlab.gat.io.File errFile = sd.getStderr();
                        org.gridlab.gat.io.File localFile = GAT.createFile(context, errFile.toGATURI());
                        if (localFile.length() > 0L) {
                            this.GATjob = null;
                            runningJobs.remove(this);
                            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
                        } else {
                            if (!debug) {
                                localFile.delete();
                            }
                            runningJobs.remove(this);
                            this.listener.jobCompleted(this);
                        }
                        break block16;
                    }
                    if (job.getExitStatus() == 0) {
                        runningJobs.remove(this);
                        this.listener.jobCompleted(this);
                        break block16;
                    }
                    this.GATjob = null;
                    runningJobs.remove(this);
                    this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
                }
                catch (Exception e) {
                    logger.fatal("Error processing callback for job: " + this, e);
                    System.exit(1);
                }
            } else if (newJobState == Job.JobState.SUBMISSION_ERROR) {
                if (tracing) {
                    Integer slot = (Integer)sd.getAttributes().get("slot");
                    Tracer.freeSlot(((GATWorkerNode)this.getResourceNode()).getHost(), slot);
                }
                try {
                    if (usingGlobus && job.getInfo().get("resManError").equals("NO_ERROR")) {
                        runningJobs.remove(this);
                        this.listener.jobCompleted(this);
                    } else {
                        this.GATjob = null;
                        runningJobs.remove(this);
                        this.listener.jobFailed(this, Job.JobListener.JobEndStatus.SUBMISSION_FAILED);
                    }
                }
                catch (GATInvocationException e) {
                    logger.fatal("Error processing callback for job: " + this, e);
                    System.exit(1);
                }
            }
        }
    }

    public static void end() {
        GAT.end();
    }

    private JobDescription prepareJob() throws Exception {
        MethodImplementation method = (MethodImplementation)this.impl;
        TaskParams taskParams = this.task.getTaskParams();
        String methodName = taskParams.getName();
        String targetPath = ((GATWorkerNode)this.getResourceNode()).getInstallDir();
        String targetHost = ((GATWorkerNode)this.getResourceNode()).getHost();
        String targetUser = ((GATWorkerNode)this.getResourceNode()).getUser();
        targetUser = userNeeded && !targetUser.isEmpty() ? targetUser + "@" : "";
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable(targetPath + "/" + WORKER_SCRIPT);
        ArrayList<String> lArgs = new ArrayList<String>();
        lArgs.add(lang);
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getWorkingDir());
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getLibPath());
        LinkedList<String> obsoleteFiles = this.getResource().clearObsoletes();
        if (obsoleteFiles != null) {
            lArgs.add("" + obsoleteFiles.size());
            for (String renaming : obsoleteFiles) {
                lArgs.add(renaming);
            }
        } else {
            lArgs.add("0");
        }
        lArgs.add(Boolean.toString(tracing));
        lArgs.add(this.getHostName());
        if (debug) {
            logger.debug("hostName " + this.getHostName());
        }
        if (tracing) {
            lArgs.add(String.valueOf(Tracer.getEventsType()));
            lArgs.add(String.valueOf(this.task.getTaskParams().getId() + 1 + Tracer.getFixedOffset()));
            int slot = Tracer.getNextSlot(targetHost);
            lArgs.add(String.valueOf(slot));
            sd.addAttribute("slot", slot);
        }
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getAppDir());
        lArgs.add(workerClasspath);
        lArgs.add(workerDebug.toString());
        lArgs.add(method.getDeclaringClass());
        lArgs.add(methodName);
        lArgs.add(Boolean.toString(taskParams.hasTargetObject()));
        int numParams = taskParams.getParameters().length;
        if (taskParams.hasReturnValue()) {
            --numParams;
        }
        lArgs.add(Integer.toString(numParams));
        for (Parameter param : taskParams.getParameters()) {
            ITExecution.ParamType type = param.getType();
            lArgs.add(Integer.toString(type.ordinal()));
            if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                lArgs.add(dPar.getDataTarget());
                if (type != ITExecution.ParamType.OBJECT_T) continue;
                if (dAccId instanceof DataAccessId.RAccessId) {
                    lArgs.add("R");
                    continue;
                }
                lArgs.add("W");
                continue;
            }
            if (type == ITExecution.ParamType.STRING_T) {
                BasicTypeParameter btParS = (BasicTypeParameter)param;
                String value = btParS.getValue().toString();
                int numSubStrings = value.split(" ").length;
                lArgs.add(Integer.toString(numSubStrings));
                lArgs.add(value);
                continue;
            }
            BasicTypeParameter btParB = (BasicTypeParameter)param;
            lArgs.add(btParB.getValue().toString());
        }
        String[] arguments = new String[lArgs.size()];
        arguments = lArgs.toArray(arguments);
        try {
            sd.setArguments(arguments);
        }
        catch (NullPointerException e) {
            StringBuilder sb = new StringBuilder("Argument null a parametre del job " + this.jobId + "(" + methodName + "@" + method.getDeclaringClass() + ")\n");
            int i = 0;
            for (Parameter param : taskParams.getParameters()) {
                sb.append("Parametre ").append(i).append("\n");
                ITExecution.ParamType type = param.getType();
                sb.append("\t Type: ").append((Object)param.getType()).append("\n");
                if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    sb.append("\t Target: ").append(dPar.getDataTarget()).append("\n");
                    if (type == ITExecution.ParamType.OBJECT_T) {
                        if (dAccId instanceof DataAccessId.RAccessId) {
                            sb.append("\t Direction: R").append("\n");
                        } else {
                            sb.append("\t Direction: W").append("\n");
                        }
                    }
                } else if (type == ITExecution.ParamType.STRING_T) {
                    BasicTypeParameter btParS = (BasicTypeParameter)param;
                    String value = btParS.getValue().toString();
                    int numSubStrings = value.split(" ").length;
                    sb.append("\t Num Substrings: " + Integer.toString(numSubStrings)).append("\n");
                    sb.append("\t Value:" + value).append("\n");
                } else {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    sb.append("\t Value: " + btParB.getValue().toString()).append("\n");
                }
                ++i;
            }
            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.SUBMISSION_FAILED);
        }
        sd.addAttribute("jobId", this.jobId);
        sd.addAttribute("sandbox.root", "/tmp/");
        sd.addAttribute("sandbox.useroot", "true");
        sd.addAttribute("sandbox.delete", "false");
        if (workerDebug.booleanValue()) {
            org.gridlab.gat.io.File outFile = GAT.createFile(context, "any:///" + JOBS_DIR + "job" + this.jobId + "_" + (Object)((Object)this.getHistory()) + ".out");
            sd.setStdout(outFile);
        }
        if (workerDebug.booleanValue() || usingGlobus) {
            org.gridlab.gat.io.File errFile = GAT.createFile(context, "any:///" + JOBS_DIR + "job" + this.jobId + "_" + (Object)((Object)this.getHistory()) + ".err");
            sd.setStderr(errFile);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(RES_ATTR, ANY_PROT + targetUser + targetHost);
        HardwareResourceDescription rd = new HardwareResourceDescription(attributes);
        logger.debug("Ready to submit job " + this.jobId + ":");
        logger.debug("  * Host: " + targetHost);
        logger.debug("  * Executable: " + sd.getExecutable());
        StringBuilder sb = new StringBuilder("  - Arguments:");
        for (String arg : sd.getArguments()) {
            sb.append(" ").append(arg);
        }
        logger.debug(sb.toString());
        return new JobDescription(sd, rd);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.getCore().toString());
        buffer.append(", [Target host: ").append(((GATWorkerNode)this.getResourceNode()).getHost()).append("]");
        buffer.append(", [User: ").append(((GATWorkerNode)this.getResourceNode()).getUser()).append("]]");
        return buffer.toString();
    }

    @Override
    public String getHostName() {
        return ((GATWorkerNode)this.getResourceNode()).getName();
    }

    static {
        workerClasspath = System.getProperty("it.worker.cp") != null && System.getProperty("it.worker.cp").compareTo("") != 0 ? System.getProperty("it.worker.cp") : "\"\"";
        runningJobs = new LinkedList();
    }
}

