/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.gat.master.GATAdaptor;
import integratedtoolkit.gat.master.GATCopy;
import integratedtoolkit.gat.master.GATJob;
import integratedtoolkit.gat.master.GATTracer;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.util.SSHManager;
import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.Job;

public class GATWorkerNode
extends COMPSsWorker {
    private static final String GAT_CLEAN_SCRIPT = "adaptors/gat/clean.sh";
    private String host = "";
    private String user = "";
    private String installDir = "";
    private String workingDir = "";
    private String appDir = "";
    private String libPath = "";
    private String queue = "";
    private int limitOfTasks = 16;
    private Job tracingJob;

    @Override
    public String getName() {
        return this.host;
    }

    public GATWorkerNode(String name, HashMap<String, String> properties) {
        super(name, properties);
        String value;
        this.host = name;
        this.installDir = properties.remove("InstallDir");
        if (this.installDir == null) {
            this.installDir = "";
        } else if (!this.installDir.endsWith(File.separator)) {
            this.installDir = this.installDir + File.separator;
        }
        this.workingDir = properties.remove("WorkingDir");
        if (this.workingDir == null) {
            this.workingDir = "";
        } else if (!this.workingDir.endsWith(File.separator)) {
            this.workingDir = this.workingDir + File.separator;
        }
        this.user = properties.remove("User");
        if (this.user == null) {
            this.user = "";
        }
        if ((this.appDir = properties.remove("AppDir")) == null) {
            this.appDir = "null";
        }
        if ((this.libPath = properties.remove("LibraryPath")) == null) {
            this.libPath = "null";
        }
        if ((this.queue = properties.remove("queue")) == null) {
            this.queue = "";
        }
        if ((value = properties.get("LimitOfTasks")) != null) {
            this.limitOfTasks = Integer.parseInt(value);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propName = entry.getKey();
            String propValue = entry.getValue();
            if (propName.startsWith("[context=job]")) {
                propName = propName.substring(13);
                GATJob.addAdaptorPreference(propName, propValue);
                if (tracing) {
                    GATTracer.addPreference(propName, propValue);
                }
            }
            if (!propName.startsWith("[context=file]")) continue;
            GATAdaptor.addFileAdaptorPreferences(propName.substring(14), propValue);
        }
        if (tracing) {
            logger.debug("Starting GAT tracer " + this.getName());
            this.tracingJob = GATTracer.startTracing(this, this.limitOfTasks);
            this.waitForTracingReady();
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public String getQueue() {
        return this.queue;
    }

    public boolean isTracingReady() {
        return !tracing || GATTracer.isReady(this.tracingJob);
    }

    public void waitForTracingReady() {
        if (!tracing) {
            return;
        }
        GATTracer.waitForTracing(this.tracingJob);
    }

    @Override
    public integratedtoolkit.types.job.Job<?> newJob(Task task, Implementation<?> impl, Resource res, Job.JobListener listener) {
        return new GATJob(task, impl, res, listener);
    }

    @Override
    public void setInternalURI(integratedtoolkit.types.data.location.URI uri) {
        String scheme = uri.getScheme();
        String user = this.user.isEmpty() ? "" : this.user + "@";
        String host = this.host;
        String filePath = uri.getPath();
        String s = scheme + user + host + "/" + filePath;
        try {
            URI gat = new URI(s);
            uri.setInternalURI(GATAdaptor.ID, gat);
        }
        catch (URISyntaxException e) {
            logger.error("Error creating new URI", e);
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    public URI getCleanScript() {
        String user = this.user.isEmpty() ? "" : this.user + "@";
        try {
            return new URI("any://" + user + this.host + "/" + this.installDir + "/" + GAT_CLEAN_SCRIPT);
        }
        catch (URISyntaxException e) {
            logger.error("Error deleting intermediate files", e);
            return null;
        }
    }

    public String getCleanParams() {
        String pars = this.workingDir + " " + tracing;
        if (tracing) {
            pars = pars + " " + this.host;
        }
        return pars;
    }

    public void processCopy(Copy c) {
        GATAdaptor.enqueueCopy(c);
    }

    @Override
    public void sendData(LogicalData srcData, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        GATCopy c = new GATCopy(srcData, source, target, tgtData, reason, listener);
        GATAdaptor.enqueueCopy(c);
    }

    @Override
    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        GATCopy c = new GATCopy(ld, source, target, tgtData, reason, listener);
        GATAdaptor.enqueueCopy(c);
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
        if (tracing) {
            System.err.println("TRACING I CLOUD NO FUNCIONEN BE");
        }
    }

    @Override
    public void announceCreation() throws Exception {
        SSHManager.registerWorker(this);
        SSHManager.announceCreation(this);
    }

    @Override
    public void announceDestruction() throws Exception {
        SSHManager.removeKey(this);
        SSHManager.announceDestruction(this);
        SSHManager.removeWorker(this);
    }

    @Override
    public String getCompletePath(ITExecution.ParamType type, String name) {
        switch (type) {
            case FILE_T: {
                return this.workingDir + name;
            }
            case OBJECT_T: {
                return this.workingDir + name;
            }
        }
        return null;
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public void generatePackage() {
        logger.debug("Generating GAT tracing package");
        GATTracer.generatePackage(this);
    }
}

