/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import java.util.TreeMap;

public class AdaptorDescription {
    public static final String NIOAdaptor = "integratedtoolkit.nio.master.NIOAdaptor";
    public static final String GATAdaptor = "integratedtoolkit.gat.master.GATAdaptor";
    public static final String WSAdaptor = "integratedtoolkit.ws.master.WSAdaptor";
    public static final String MIN_PORT = "MinPort";
    public static final String MAX_PORT = "MaxPort";
    private int minPort = 0;
    private int maxPort = 0;
    private final String name;

    public AdaptorDescription(String name) {
        this.name = name;
    }

    public AdaptorDescription(String name, int minPort, int maxPort) {
        this(name);
        this.minPort = minPort;
        this.maxPort = maxPort;
    }

    public String getName() {
        return this.name;
    }

    public int[] getPortRange() {
        return new int[]{this.minPort, this.maxPort};
    }

    public void setPortRange(int minPort, int maxPort) {
        this.minPort = minPort;
        this.maxPort = maxPort;
    }

    public boolean portRangeIsValid() {
        return this.minPort > 0 && this.maxPort >= this.minPort;
    }

    public void checkAdaptorProperties() throws Exception {
        if (!this.portRangeIsValid()) {
            String message = "No valid port range provided. [project.xml and resources.xml need to define overlapping ranges (if project is set)]";
            System.out.println(message);
            throw new Exception(message);
        }
    }

    public static TreeMap<String, AdaptorDescription> merge(TreeMap<String, AdaptorDescription> projectAdaptorsDesc, TreeMap<String, AdaptorDescription> resourceAdaptorsDesc) throws Exception {
        String[] possibleAdaptors;
        if (projectAdaptorsDesc.size() == 0 && resourceAdaptorsDesc.size() > 0) {
            return resourceAdaptorsDesc;
        }
        TreeMap<String, AdaptorDescription> aDesc = new TreeMap<String, AdaptorDescription>();
        for (String adaptorName : possibleAdaptors = new String[]{NIOAdaptor, GATAdaptor}) {
            AdaptorDescription projectAdaptor = projectAdaptorsDesc.get(adaptorName);
            AdaptorDescription resourceAdaptor = resourceAdaptorsDesc.get(adaptorName);
            if (resourceAdaptor == null || !resourceAdaptor.portRangeIsValid()) continue;
            int[] rPorts = resourceAdaptor.getPortRange();
            if (projectAdaptor != null) {
                int[] pPorts = projectAdaptor.getPortRange();
                int minPort = rPorts[0];
                int maxPort = rPorts[1];
                if (pPorts[0] > -1) {
                    int n = minPort = rPorts[0] > pPorts[0] ? rPorts[0] : pPorts[0];
                }
                if (pPorts[1] > -1) {
                    maxPort = rPorts[1] < pPorts[1] ? rPorts[1] : pPorts[1];
                }
                aDesc.put(adaptorName, new AdaptorDescription(adaptorName, minPort, maxPort));
                continue;
            }
            aDesc.put(adaptorName, new AdaptorDescription(adaptorName, rPorts[0], rPorts[1]));
        }
        return aDesc;
    }
}

