/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.opennebula.client.ClientConfigurationException;
import org.opennebula.client.OneResponse;

public class Client {
    private String oneAuth;
    private String oneEndPoint;
    private XmlRpcClient client;

    public Client() throws ClientConfigurationException {
        this.setOneAuth(null);
        this.setOneEndPoint(null);
    }

    public Client(String string, String string2) throws ClientConfigurationException {
        this.setOneAuth(string);
        this.setOneEndPoint(string2);
    }

    public OneResponse call(String string, Object ... objectArray) {
        boolean bl = false;
        String string2 = null;
        try {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = this.oneAuth;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i + 1] = objectArray[i];
            }
            Object[] objectArray3 = (Object[])this.client.execute("one." + string, objectArray2);
            bl = (Boolean)objectArray3[0];
            if (objectArray3.length > 1) {
                try {
                    string2 = (String)objectArray3[1];
                }
                catch (ClassCastException classCastException) {
                    string2 = ((Integer)objectArray3[1]).toString();
                }
            }
        }
        catch (XmlRpcException xmlRpcException) {
            string2 = xmlRpcException.getMessage();
        }
        return new OneResponse(bl, string2);
    }

    public OneResponse get_version() {
        return this.call("system.version", new Object[0]);
    }

    private void setOneAuth(String string) throws ClientConfigurationException {
        this.oneAuth = string;
        try {
            if (this.oneAuth == null) {
                String string2 = System.getenv("ONE_AUTH");
                File file = string2 != null && string2.length() != 0 ? new File(string2) : new File(System.getenv("HOME") + "/.one/one_auth");
                this.oneAuth = new BufferedReader(new FileReader(file)).readLine();
            }
            this.oneAuth = this.oneAuth.trim();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClientConfigurationException("ONE_AUTH file not present");
        }
        catch (IOException iOException) {
            throw new ClientConfigurationException("ONE_AUTH file unreadable");
        }
    }

    private void setOneEndPoint(String string) throws ClientConfigurationException {
        Object object;
        this.oneEndPoint = "http://localhost:2633/RPC2";
        if (string != null) {
            this.oneEndPoint = string;
        } else {
            object = System.getenv("ONE_XMLRPC");
            if (object != null && ((String)object).length() != 0) {
                this.oneEndPoint = object;
            }
        }
        object = new XmlRpcClientConfigImpl();
        try {
            ((XmlRpcClientConfigImpl)object).setServerURL(new URL(this.oneEndPoint));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClientConfigurationException("The URL " + this.oneEndPoint + " is malformed.");
        }
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)object);
    }
}

