/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vm;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VirtualMachine
extends PoolElement {
    private static final String METHOD_PREFIX = "vm.";
    private static final String ALLOCATE = "vm.allocate";
    private static final String INFO = "vm.info";
    private static final String DEPLOY = "vm.deploy";
    private static final String ACTION = "vm.action";
    private static final String MIGRATE = "vm.migrate";
    private static final String SAVEDISK = "vm.savedisk";
    private static final String CHOWN = "vm.chown";
    private static final String CHMOD = "vm.chmod";
    private static final String MONITORING = "vm.monitoring";
    private static final String ATTACH = "vm.attach";
    private static final String DETACH = "vm.detach";
    private static final String RENAME = "vm.rename";
    private static final String UPDATE = "vm.update";
    private static final String RESIZE = "vm.resize";
    private static final String ATTACHNIC = "vm.attachnic";
    private static final String DETACHNIC = "vm.detachnic";
    private static final String SNAPSHOTCREATE = "vm.snapshotcreate";
    private static final String SNAPSHOTREVERT = "vm.snapshotrevert";
    private static final String SNAPSHOTDELETE = "vm.snapshotdelete";
    private static final String RECOVER = "vm.recover";
    private static final String[] VM_STATES = new String[]{"INIT", "PENDING", "HOLD", "ACTIVE", "STOPPED", "SUSPENDED", "DONE", "FAILED", "POWEROFF", "UNDEPLOYED"};
    private static final String[] SHORT_VM_STATES = new String[]{"init", "pend", "hold", "actv", "stop", "susp", "done", "fail", "poff", "unde"};
    private static final String[] LCM_STATE = new String[]{"LCM_INIT", "PROLOG", "BOOT", "RUNNING", "MIGRATE", "SAVE_STOP", "SAVE_SUSPEND", "SAVE_MIGRATE", "PROLOG_MIGRATE", "PROLOG_RESUME", "EPILOG_STOP", "EPILOG", "SHUTDOWN", "CANCEL", "FAILURE", "CLEANUP_RESUBMIT", "UNKNOWN", "HOTPLUG", "SHUTDOWN_POWEROFF", "BOOT_UNKNOWN", "BOOT_POWEROFF", "BOOT_SUSPENDED", "BOOT_STOPPED", "CLEANUP_DELETE", "HOTPLUG_SNAPSHOT", "HOTPLUG_NIC", "HOTPLUG_SAVEAS", "HOTPLUG_SAVEAS_POWEROFF", "HOTPLUG_SAVEAS_SUSPENDED", "SHUTDOWN_UNDEPLOY", "EPILOG_UNDEPLOY", "PROLOG_UNDEPLOY", "BOOT_UNDEPLOY"};
    private static final String[] SHORT_LCM_STATES = new String[]{null, "prol", "boot", "runn", "migr", "save", "save", "save", "migr", "prol", "epil", "epil", "shut", "shut", "fail", "clea", "unkn", "hotp", "shut", "boot", "boot", "boot", "boot", "clea", "snap", "hotp", "hotp", "hotp", "hotp", "shut", "epil", "prol", "boot"};

    public VirtualMachine(int n, Client client) {
        super(n, client);
    }

    protected VirtualMachine(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return VirtualMachine.allocate(client, string, false);
    }

    public static OneResponse allocate(Client client, String string, boolean bl) {
        return client.call(ALLOCATE, string, bl);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse resize(Client client, int n, String string, boolean bl) {
        return client.call(RESIZE, n, string, bl);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return VirtualMachine.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return VirtualMachine.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VirtualMachine.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse monitoring(Client client, int n) {
        return client.call(MONITORING, n);
    }

    public static OneResponse diskAttach(Client client, int n, String string) {
        return client.call(ATTACH, n, string);
    }

    public static OneResponse diskDetach(Client client, int n, int n2) {
        return client.call(DETACH, n, n2);
    }

    public static OneResponse diskSnapshot(Client client, int n, int n2, String string, String string2, boolean bl) {
        return client.call(SAVEDISK, n, n2, string, string2, bl);
    }

    public static OneResponse nicAttach(Client client, int n, String string) {
        return client.call(ATTACHNIC, n, string);
    }

    public static OneResponse nicDetach(Client client, int n, int n2) {
        return client.call(DETACHNIC, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse snapshotCreate(Client client, int n, String string) {
        return client.call(SNAPSHOTCREATE, n, string);
    }

    public static OneResponse snapshotRevert(Client client, int n, int n2) {
        return client.call(SNAPSHOTREVERT, n, n2);
    }

    public static OneResponse snapshotDelete(Client client, int n, int n2) {
        return client.call(SNAPSHOTDELETE, n, n2);
    }

    public static OneResponse recover(Client client, int n, boolean bl) {
        return client.call(RECOVER, n, bl);
    }

    public OneResponse info() {
        OneResponse oneResponse = VirtualMachine.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse deploy(int n, boolean bl, int n2) {
        return this.client.call(DEPLOY, this.id, n, bl, n2);
    }

    public OneResponse deploy(int n) {
        return this.deploy(n, false, -1);
    }

    protected OneResponse action(String string) {
        return this.client.call(ACTION, string, this.id);
    }

    public OneResponse migrate(int n, boolean bl, boolean bl2) {
        return this.client.call(MIGRATE, this.id, n, bl, bl2);
    }

    public OneResponse migrate(int n, boolean bl) {
        return this.migrate(n, bl, false);
    }

    public OneResponse migrate(int n) {
        return this.migrate(n, false, false);
    }

    public OneResponse chown(int n, int n2) {
        return VirtualMachine.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return VirtualMachine.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VirtualMachine.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VirtualMachine.chmod(this.client, this.id, n);
    }

    public OneResponse monitoring() {
        return VirtualMachine.monitoring(this.client, this.id);
    }

    public OneResponse diskAttach(String string) {
        return VirtualMachine.diskAttach(this.client, this.id, string);
    }

    public OneResponse diskDetach(int n) {
        return VirtualMachine.detachdisk(this.client, this.id, n);
    }

    public OneResponse diskSnapshot(int n, String string, String string2, boolean bl) {
        return VirtualMachine.diskSnapshot(this.client, this.id, n, string, string2, bl);
    }

    public OneResponse diskSnapshot(int n, String string) {
        return this.diskSnapshot(n, string, "", false);
    }

    public OneResponse diskSnapshot(int n, String string, boolean bl) {
        return this.diskSnapshot(n, string, "", bl);
    }

    public OneResponse nicAttach(String string) {
        return VirtualMachine.nicAttach(this.client, this.id, string);
    }

    public OneResponse nicDetach(int n) {
        return VirtualMachine.nicDetach(this.client, this.id, n);
    }

    public OneResponse rename(String string) {
        return VirtualMachine.rename(this.client, this.id, string);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VirtualMachine.update(this.client, this.id, string, bl);
    }

    public OneResponse resize(String string, boolean bl) {
        return VirtualMachine.resize(this.client, this.id, string, bl);
    }

    public OneResponse snapshotCreate(String string) {
        return VirtualMachine.snapshotCreate(this.client, this.id, string);
    }

    public OneResponse snapshotRevert(int n) {
        return VirtualMachine.snapshotRevert(this.client, this.id, n);
    }

    public OneResponse snapshotDelete(int n) {
        return VirtualMachine.snapshotDelete(this.client, this.id, n);
    }

    public OneResponse recover(boolean bl) {
        return VirtualMachine.recover(this.client, this.id, bl);
    }

    public OneResponse shutdown() {
        return this.shutdown(false);
    }

    public OneResponse shutdown(boolean bl) {
        String string = bl ? "shutdown-hard" : "shutdown";
        return this.action(string);
    }

    public OneResponse undeploy(boolean bl) {
        String string = bl ? "undeploy-hard" : "undeploy";
        return this.action(string);
    }

    public OneResponse poweroff() {
        return this.poweroff(false);
    }

    public OneResponse poweroff(boolean bl) {
        String string = bl ? "poweroff-hard" : "poweroff";
        return this.action(string);
    }

    public OneResponse reboot() {
        return this.action("reboot");
    }

    public OneResponse reboot(boolean bl) {
        String string = bl ? "reboot-hard" : "reboot";
        return this.action(string);
    }

    public OneResponse hold() {
        return this.action("hold");
    }

    public OneResponse release() {
        return this.action("release");
    }

    public OneResponse stop() {
        return this.action("stop");
    }

    public OneResponse suspend() {
        return this.action("suspend");
    }

    public OneResponse resume() {
        return this.action("resume");
    }

    public OneResponse delete() {
        return this.delete(false);
    }

    public OneResponse delete(boolean bl) {
        String string = bl ? "delete-recreate" : "delete";
        return this.action(string);
    }

    public OneResponse boot() {
        return this.action("boot");
    }

    public OneResponse resched() {
        return this.action("resched");
    }

    public OneResponse unresched() {
        return this.action("unresched");
    }

    @Override
    public int state() {
        return super.state();
    }

    public String stateStr() {
        int n = this.state();
        return n != -1 ? VM_STATES[this.state()] : null;
    }

    public int lcmState() {
        String string = this.xpath("LCM_STATE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String lcmStateStr() {
        int n = this.lcmState();
        return n != -1 ? LCM_STATE[n] : null;
    }

    public String status() {
        int n;
        int n2 = this.state();
        String string = null;
        if (n2 != -1 && (string = SHORT_VM_STATES[n2]).equals("actv") && (n = this.lcmState()) != -1) {
            string = SHORT_LCM_STATES[n];
        }
        return string;
    }

    @Deprecated
    public static OneResponse attachdisk(Client client, int n, String string) {
        return VirtualMachine.diskAttach(client, n, string);
    }

    @Deprecated
    public static OneResponse detachdisk(Client client, int n, int n2) {
        return VirtualMachine.diskDetach(client, n, n2);
    }

    @Deprecated
    public OneResponse savedisk(int n, String string) {
        return this.diskSnapshot(n, string);
    }

    public OneResponse savedisk(int n, String string, String string2) {
        return this.diskSnapshot(n, string, string2, false);
    }

    @Deprecated
    public OneResponse attachdisk(String string) {
        return this.diskAttach(string);
    }

    @Deprecated
    public OneResponse detachdisk(int n) {
        return this.diskDetach(n);
    }

    @Deprecated
    public OneResponse cancel() {
        return this.action("cancel");
    }

    @Deprecated
    public OneResponse reset() {
        return this.action("reset");
    }

    @Deprecated
    public OneResponse finalizeVM() {
        return this.action("finalize");
    }

    @Deprecated
    public OneResponse resubmit() {
        return this.action("resubmit");
    }

    @Deprecated
    public OneResponse restart() {
        return this.action("restart");
    }

    @Deprecated
    public OneResponse liveMigrate(int n) {
        return this.migrate(n, false);
    }
}

