/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.one;

import integratedtoolkit.connectors.AbstractSSHConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.one.VMTemplate;
import integratedtoolkit.connectors.utils.KeyManager;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.HashMap;
import org.opennebula.client.Client;
import org.opennebula.client.ClientConfigurationException;
import org.opennebula.client.OneResponse;
import org.opennebula.client.template.Template;
import org.opennebula.client.template.TemplatePool;
import org.opennebula.client.vm.VirtualMachine;

public class ONE
extends AbstractSSHConnector {
    private Client client;
    private static final String ENDPOINT_PROP = "Server";
    private static final String ONE_USER_PROP = "one-user";
    private static final String ONE_PWD_PROP = "one-password";
    private static final String RUNNING = "runn";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;

    public ONE(String providerName, HashMap<String, String> props) throws ConnectorException {
        super(providerName, props);
        try {
            this.client = new Client(props.get(ONE_USER_PROP) + ":" + props.get(ONE_PWD_PROP), props.get(ENDPOINT_PROP));
        }
        catch (ClientConfigurationException e) {
            logger.error((Object)"Error configuring ONE client.", (Throwable)e);
            throw new ConnectorException("Error configuring ONE client.");
        }
    }

    public void destroy(Object vm) throws ConnectorException {
        int vmId = Integer.parseInt((String)vm);
        VirtualMachine virtualMachine = new VirtualMachine(vmId, this.client);
        virtualMachine.shutdown();
    }

    public Object create(String name, CloudMethodResourceDescription requested) throws ConnectorException {
        Template template = this.classifyMachine(requested.getProcessorCoreCount(), requested.getMemoryPhysicalSize(), requested.getStorageElemSize());
        try {
            String pubKey = KeyManager.getPublicKey((String)KeyManager.getKeyPair());
            VMTemplate vmTemp = new VMTemplate(template.info().getMessage());
            vmTemp.setImage(requested.getImage().getName());
            vmTemp.setPublicKey(pubKey);
            OneResponse resp = template.instantiate(name, false, vmTemp.getString());
            if (resp.isError()) {
                throw new ConnectorException(resp.getErrorMessage());
            }
            return resp.getMessage();
        }
        catch (ClassCastException e) {
            logger.error((Object)"DOM exception when serializing template.", (Throwable)e);
            throw new ConnectorException((Exception)e);
        }
        catch (Exception e) {
            logger.error((Object)"Unknown exception.", (Throwable)e);
            throw new ConnectorException(e);
        }
    }

    public CloudMethodResourceDescription waitUntilCreation(Object vm, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = new CloudMethodResourceDescription();
        int vmId = Integer.parseInt((String)vm);
        VirtualMachine virtualMachine = new VirtualMachine(vmId, this.client);
        virtualMachine.info();
        int tries = 0;
        while (virtualMachine.status() == null || !virtualMachine.status().equals(RUNNING)) {
            if ((long)tries * 5L > 1800L) {
                throw new ConnectorException("Maximum VM creation time reached.");
            }
            ++tries;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            virtualMachine.info();
        }
        String ip = virtualMachine.xpath("//NIC/IP");
        granted.setName(ip);
        granted.setType(requested.getType());
        String cpu = virtualMachine.xpath("//TEMPLATE/VCPU");
        granted.setProcessorCoreCount(Integer.parseInt(cpu));
        granted.setProcessorArchitecture(requested.getProcessorArchitecture());
        granted.setProcessorSpeed(requested.getProcessorSpeed());
        String memory = virtualMachine.xpath("//TEMPLATE/MEMORY");
        granted.setMemoryPhysicalSize((float)Integer.parseInt(memory) / 1024.0f);
        granted.setMemoryAccessTime(requested.getMemoryAccessTime());
        granted.setMemorySTR(requested.getMemorySTR());
        granted.setMemoryVirtualSize(requested.getMemoryVirtualSize());
        String homeSize = virtualMachine.xpath("//TEMPLATE/DISK[TYPE=\"fs\"]/SIZE");
        granted.setStorageElemSize((float)Integer.parseInt(homeSize) / 1024.0f);
        granted.setStorageElemAccessTime(requested.getStorageElemAccessTime());
        granted.setStorageElemSTR(requested.getStorageElemSTR());
        granted.setOperatingSystemType("Linux");
        granted.setSlots(requested.getSlots());
        granted.getAppSoftware().addAll(requested.getAppSoftware());
        granted.setImage(requested.getImage());
        granted.setValue(this.getMachineCostPerHour(granted).floatValue());
        return granted;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription rd) {
        return 0.0f;
    }

    public long getTimeSlot() {
        return 0L;
    }

    private Template classifyMachine(int cpu, float memory, float disk) {
        logger.debug((Object)("Classifying machine with CPU=" + cpu + ", Mem=" + memory + ", Disk=" + disk));
        TemplatePool pool = new TemplatePool(this.client);
        int minCPU = Integer.MAX_VALUE;
        float minMem = Float.MAX_VALUE;
        int minDisk = Integer.MAX_VALUE;
        Template minTemplate = null;
        pool.info();
        logger.debug((Object)("There are a total of " + pool.getLength() + " templates."));
        for (Template temp : pool) {
            temp.info();
            int tmpCPU = Integer.valueOf(temp.xpath("//CPU"));
            float tmpMem = Integer.valueOf(temp.xpath("//MEMORY")).intValue();
            int tmpDisk = Integer.valueOf(temp.xpath("//DISK[TYPE=\"fs\"]/SIZE"));
            logger.debug((Object)("Comparing with template " + temp.getName() + ": CPU=" + tmpCPU + ", Mem=" + tmpMem + ", Disk=" + tmpDisk));
            if (cpu > tmpCPU || tmpCPU > minCPU || !(memory <= tmpMem) || !(tmpMem <= minMem) || !(disk <= (float)tmpDisk) || tmpDisk > minDisk || tmpCPU >= minCPU && !(tmpMem < minMem) && tmpDisk >= minDisk) continue;
            minCPU = tmpCPU;
            minMem = tmpMem;
            minDisk = tmpDisk;
            minTemplate = temp;
        }
        if (minTemplate != null) {
            logger.debug((Object)("Found a matching template: " + minTemplate.getName()));
        }
        return minTemplate;
    }
}

