/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components;

import integratedtoolkit.types.resources.Worker;

public interface ResourceUser {
    public void createdResources(Worker<?> var1);

    public WorkloadStatus getWorkload();

    public static class WorkloadStatus {
        private int coreCount;
        private long[] coreMinTime;
        private long[] coreMeanTime;
        private long[] coreMaxTime;
        private int noResourceCount;
        private int[] noResourceCounts;
        private int ordinaryCount;
        private int[] ordinaryCounts;
        private int toRescheduleCount;
        private int[] toRescheduleCounts;
        private int[] runningCounts;
        private long[] runningCoreMeanTime;
        private int[] waitingCounts;

        public WorkloadStatus(int coreCount) {
            this.coreCount = coreCount;
            this.coreMinTime = new long[coreCount];
            this.coreMeanTime = new long[coreCount];
            this.coreMaxTime = new long[coreCount];
            this.noResourceCounts = new int[coreCount];
            this.ordinaryCounts = new int[coreCount];
            this.toRescheduleCounts = new int[coreCount];
            this.waitingCounts = new int[coreCount];
            this.runningCounts = new int[coreCount];
            this.runningCoreMeanTime = new long[coreCount];
        }

        public int getCoreCount() {
            return this.coreCount;
        }

        public long getCoreMeanTime(int coreId) {
            return this.coreMeanTime[coreId];
        }

        public long getCoreMaxTime(int coreId) {
            return this.coreMaxTime[coreId];
        }

        public long getCoreMinTime(int coreId) {
            return this.coreMinTime[coreId];
        }

        public int getNoResourceCount() {
            return this.noResourceCount;
        }

        public int[] getNoResourceCounts() {
            return this.noResourceCounts;
        }

        public int[] getReadyTaskCounts() {
            int[] counts = new int[this.coreCount];
            for (int coreId = 0; coreId < this.coreCount; ++coreId) {
                counts[coreId] = this.noResourceCounts[coreId] + this.ordinaryCounts[coreId] + this.toRescheduleCounts[coreId];
            }
            return counts;
        }

        public int[] getOrdinaryCounts() {
            return this.ordinaryCounts;
        }

        public int[] getWaitingTaskCounts() {
            return this.waitingCounts;
        }

        public long getRunningCoreMeanTime(int coreId) {
            return this.runningCoreMeanTime[coreId];
        }

        public int[] getRunningTaskCounts() {
            return this.runningCounts;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TIMESTAMP = ").append(String.valueOf(System.currentTimeMillis())).append("\n");
            sb.append("LOAD_INFO = [").append("\n");
            for (int coreId = 0; coreId < this.coreCount; ++coreId) {
                sb.append("\t").append("CORE_INFO = [").append("\n");
                sb.append("\t").append("\t").append("COREID = ").append(coreId).append("\n");
                sb.append("\t").append("\t").append("NO_RESOURCE = ").append(this.noResourceCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("TO_RESCHEDULE = ").append(this.toRescheduleCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("ORDINARY = ").append(this.ordinaryCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("RUNNING = ").append(this.runningCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("MIN = ").append(this.coreMinTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("MEAN = ").append(this.coreMeanTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("MAX = ").append(this.coreMaxTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("RUNNING_MEAN = ").append(this.runningCoreMeanTime[coreId]).append("\n");
                sb.append("\t").append("]").append("\n");
            }
            sb.append("]").append("\n");
            return sb.toString();
        }

        public void registerTimes(int coreId, long minTime, long avgTime, long maxTime) {
            if (coreId < this.coreCount) {
                this.coreMinTime[coreId] = minTime;
                this.coreMeanTime[coreId] = avgTime;
                this.coreMaxTime[coreId] = maxTime;
            }
        }

        public void registerReadyTaskCounts(int coreId, int noResource, int regular, int toReschedule) {
            this.noResourceCount += noResource;
            this.ordinaryCount += regular;
            this.toRescheduleCount += toReschedule;
            this.noResourceCounts[coreId] = noResource;
            this.ordinaryCounts[coreId] = regular;
            this.toRescheduleCounts[coreId] = toReschedule;
        }

        public void registerRunningTask(int coreId, int runningTasks, long meanRunningTime) {
            this.runningCoreMeanTime[coreId] = meanRunningTime;
            this.runningCounts[coreId] = runningTasks;
        }
    }
}

