/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.util.ResourceManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.w3c.dom.Node;

public class CloudImageDescription {
    private final String name;
    private String providerName;
    private final HashMap<String, String> properties;
    private final LinkedList<String[]> packages;
    private final TreeSet<String> softwareApps;
    private String arch = "[unassigned]";
    private String operativeSystem = "[unassinged]";
    private String adaptor;
    private TreeMap<String, AdaptorDescription> adaptorsDescription = new TreeMap();
    private final HashMap<String, String> sharedDisks;

    public CloudImageDescription(String cloudProviderName, Node resourcesNode, Node projectNode, HashMap<String, String> providerProperties) {
        Node child;
        int i;
        this.providerName = cloudProviderName;
        this.name = projectNode.getAttributes().getNamedItem("name").getTextContent();
        this.packages = new LinkedList();
        this.sharedDisks = new HashMap();
        this.softwareApps = new TreeSet();
        this.properties = new HashMap();
        for (i = 0; i < projectNode.getChildNodes().getLength(); ++i) {
            child = projectNode.getChildNodes().item(i);
            if (child.getNodeName().compareTo("InstallDir") == 0) {
                this.properties.put("InstallDir", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("WorkingDir") == 0) {
                this.properties.put("WorkingDir", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("AppDir") == 0) {
                this.properties.put("AppDir", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("LibraryPath") == 0) {
                this.properties.put("LibraryPath", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("User") == 0) {
                this.properties.put("User", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("Password") == 0) {
                this.properties.put("Password", child.getTextContent());
                continue;
            }
            if (child.getNodeName().compareTo("CommAdaptor") == 0) {
                this.adaptor = child.getTextContent();
                continue;
            }
            if (child.getNodeName().compareTo("Package") != 0) continue;
            String[] p = new String[2];
            for (int j = 0; j < child.getChildNodes().getLength(); ++j) {
                Node packageChild = child.getChildNodes().item(j);
                if (packageChild.getNodeName().compareTo("Source") == 0) {
                    p[0] = packageChild.getTextContent();
                    continue;
                }
                if (packageChild.getNodeName().compareTo("Target") == 0) {
                    p[1] = packageChild.getTextContent();
                    continue;
                }
                if (packageChild.getNodeName().compareTo("IncludedSoftware") != 0) continue;
                for (int app = 0; app < packageChild.getChildNodes().getLength(); ++app) {
                    Node appNode = packageChild.getChildNodes().item(app);
                    if (appNode.getNodeName().compareTo("Software") != 0) continue;
                    this.softwareApps.add(appNode.getTextContent());
                }
            }
            this.packages.add(p);
        }
        this.adaptorsDescription = ResourceManager.parseAdaptors(resourcesNode);
        for (i = 0; i < resourcesNode.getChildNodes().getLength(); ++i) {
            child = resourcesNode.getChildNodes().item(i);
            if (child.getNodeName().compareTo("ApplicationSoftware") == 0) {
                for (int app = 0; app < child.getChildNodes().getLength(); ++app) {
                    Node appNode = child.getChildNodes().item(app);
                    if (appNode.getNodeName().compareTo("Software") != 0) continue;
                    this.softwareApps.add(appNode.getTextContent());
                }
                continue;
            }
            if (child.getNodeName().compareTo("SharedDisks") == 0) {
                for (int diskIndex = 0; diskIndex < child.getChildNodes().getLength(); ++diskIndex) {
                    Node sharedDisk = child.getChildNodes().item(diskIndex);
                    if (sharedDisk.getNodeName().compareTo("Disk") != 0) continue;
                    String diskName = sharedDisk.getAttributes().getNamedItem("Name").getTextContent();
                    String mountPoint = "";
                    for (int j = 0; j < sharedDisk.getChildNodes().getLength(); ++j) {
                        if (sharedDisk.getChildNodes().item(j).getNodeName().compareTo("MountPoint") != 0) continue;
                        mountPoint = sharedDisk.getChildNodes().item(j).getTextContent();
                    }
                    this.sharedDisks.put(diskName, mountPoint);
                }
                continue;
            }
            if (child.getNodeName().compareTo("OSType") == 0) {
                this.operativeSystem = child.getTextContent();
                continue;
            }
            if (child.getNodeName().compareTo("Architecture") != 0) continue;
            this.arch = child.getTextContent();
        }
        this.properties.putAll(providerProperties);
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getArch() {
        return this.arch;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public LinkedList<String[]> getPackages() {
        return this.packages;
    }

    public HashMap<String, String> getSharedDisks() {
        return this.sharedDisks;
    }

    public String getOperativeSystem() {
        return this.operativeSystem;
    }

    public TreeSet<String> getSoftwareApps() {
        return this.softwareApps;
    }

    public String getAdaptor() {
        return this.adaptor;
    }

    public TreeMap<String, AdaptorDescription> getAdaptorsDescription() {
        return this.adaptorsDescription;
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("IMAGE = [").append("\n");
        sb.append(prefix).append("\t").append("NAME = ").append(this.name).append("\n");
        sb.append(prefix).append("\t").append("COMM_ADAPTOR = ").append(this.adaptor).append("\n");
        sb.append(prefix).append("\t").append("ARCH = ").append(this.arch).append("\n");
        sb.append(prefix).append("\t").append("OS = ").append(this.operativeSystem).append("\n");
        sb.append(prefix).append("\t").append("INSTALL_DIR = ").append(this.properties.get("InstallDir")).append("\n");
        sb.append(prefix).append("\t").append("WORKING_DIR = ").append(this.properties.get("WorkingDir")).append("\n");
        sb.append(prefix).append("\t").append("APP_DIR = ").append(this.properties.get("AppDir")).append("\n");
        sb.append(prefix).append("\t").append("LIBRARY_PATH = ").append(this.properties.get("LibraryPath")).append("\n");
        sb.append(prefix).append("\t").append("USER = ").append(this.properties.get("User")).append("\n");
        sb.append(prefix).append("\t").append("PASSWORD = ").append(this.properties.get("Password")).append("\n");
        sb.append(prefix).append("\t").append("SHARED_DISKS = [").append("\n");
        for (Map.Entry<String, String> entry : this.sharedDisks.entrySet()) {
            sb.append(prefix).append("\t").append("\t").append("SHARED_DISK = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("DISK_NAME = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("MOUNT_POINT = ").append(entry.getValue()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("PACKAGES = ").append("\n");
        for (String[] pack : this.packages) {
            sb.append(prefix).append("\t").append("\t").append("PACKAGE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("SOURCE = ").append(pack[0]).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("TARGET = ").append(pack[1]).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("SOFTWARE = ").append("\n");
        for (String app : this.softwareApps) {
            sb.append(prefix).append("\t").append("\t").append("APPLICATION = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("NAME = ").append(app).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

