/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ServiceResourceDescription;
import integratedtoolkit.types.resources.Worker;
import java.util.HashMap;
import java.util.TreeMap;

public class ServiceWorker
extends Worker<ServiceResourceDescription> {
    private String wsdl;

    public ServiceWorker(String wsdl, ServiceResourceDescription description, HashMap<String, String> properties, Integer maxTaskCount) throws Exception {
        super(wsdl, description, new TreeMap<String, AdaptorDescription>(){
            {
                this.put("integratedtoolkit.ws.master.WSAdaptor", new AdaptorDescription("integratedtoolkit.ws.master.WSAdaptor"));
            }
        }, properties, maxTaskCount);
        this.wsdl = wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public String getServiceName() {
        return ((ServiceResourceDescription)this.description).getServiceName();
    }

    public String getNamespace() {
        return ((ServiceResourceDescription)this.description).getNamespace();
    }

    public String getPort() {
        return ((ServiceResourceDescription)this.description).getPort();
    }

    public String getName() {
        return this.wsdl;
    }

    @Override
    public Integer fitCount(Implementation<?> impl) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasAvailable(ServiceResourceDescription consumption) {
        return true;
    }

    @Override
    public boolean reserveResource(ServiceResourceDescription consumption) {
        return true;
    }

    @Override
    public void releaseResource(ServiceResourceDescription consumption) {
    }

    public Resource.Type getType() {
        return Resource.Type.SERVICE;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<CPU>").append("</CPU>").append("\n");
        sb.append(prefix).append("<Core>").append("</Core>").append("\n");
        sb.append(prefix).append("<Memory>").append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append("</Disk>").append("\n");
        sb.append(prefix).append("<Provider>").append("</Provider>").append("\n");
        sb.append(prefix).append("<Image>").append("</Image>").append("\n");
        return sb.toString();
    }

    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return this.getName().compareTo(t.getName());
            }
            case WORKER: {
                return -1;
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation implementation) {
        switch (implementation.getType()) {
            case SERVICE: {
                ServiceResourceDescription s = (ServiceResourceDescription)implementation.getRequirements();
                return ((ServiceResourceDescription)this.description).getNamespace().compareTo(s.getNamespace()) == 0 && ((ServiceResourceDescription)this.description).getServiceName().compareTo(s.getServiceName()) == 0 && ((ServiceResourceDescription)this.description).getPort().compareTo(s.getPort()) == 0;
            }
        }
        return false;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = SERVICE").append("\n");
        return sb.toString();
    }
}

