/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.CloudProvider;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CoreManager;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class CloudManager {
    private static boolean useCloud;
    private static HashMap<String, CloudProvider> providers;
    private static HashMap<String, CloudProvider> VM2Provider;
    private static final LinkedList<ResourceCreationRequest> pendingRequests;
    private static int[] pendingCoreCount;
    private static final Logger resourcesLogger;
    private static final Logger runtimeLogger;

    public static void initialize() {
        runtimeLogger.info((Object)"Initializing Cloud Manager");
        useCloud = false;
        providers = new HashMap();
        VM2Provider = new HashMap();
        CloudManager.loadConnectors();
    }

    public static void setUseCloud(boolean useCloud) {
        CloudManager.useCloud = useCloud;
    }

    private static void loadConnectors() {
        runtimeLogger.info((Object)"Loading connectors");
        try {
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            String itHome = System.getenv("IT_HOME");
            if (itHome != null && !itHome.isEmpty()) {
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                File directory = new File(itHome + File.separator + "connectors");
                if (directory.exists()) {
                    File[] jarList;
                    for (File jar : jarList = directory.listFiles()) {
                        try {
                            runtimeLogger.debug((Object)("Loading " + jar.getAbsolutePath()));
                            method.invoke((Object)sysloader, new File(jar.getAbsolutePath()).toURI().toURL());
                        }
                        catch (Exception e) {
                            resourcesLogger.error((Object)("ERROR_MSG = [COULD NOT LOAD CONNECTOR JAR " + jar.getAbsolutePath()), (Throwable)e);
                            resourcesLogger.error((Object)"]");
                            runtimeLogger.error((Object)("COULD NOT LOAD CONNECTOR JAR " + jar.getAbsolutePath()), (Throwable)e);
                        }
                    }
                } else {
                    resourcesLogger.warn((Object)"WARN_MSG = [CONNECTORS FOLDER NOT DEFINED, NO DEFAULT CONNECTORS LOADED]");
                    runtimeLogger.warn((Object)"WARN: Connectors folder not defined, no default connectors loaded");
                }
            } else {
                resourcesLogger.warn((Object)"WARN_MSG = [IT_HOME NOT DEFINED, NO DEFAULT CONNECTORS LOADED]");
                runtimeLogger.warn((Object)"WARN: IT_HOME not defined, no default connectors loaded");
            }
        }
        catch (Exception e) {
            resourcesLogger.error((Object)"ERROR_MSG = [CAN NOT LOAD ANY CONNECTOR ", (Throwable)e);
            resourcesLogger.error((Object)"]");
            runtimeLogger.error((Object)"ERROR: Cannot load any connector", (Throwable)e);
        }
    }

    public static boolean isUseCloud() {
        return useCloud;
    }

    public static void newCloudProvider(String name, Integer limitOfVMs, String connectorPath, HashMap<String, String> connectorProperties) throws Exception {
        CloudProvider cp = new CloudProvider(connectorPath, limitOfVMs, connectorProperties, name);
        providers.put(name, cp);
    }

    public static void addImageToProvider(String providerName, CloudImageDescription cid) throws Exception {
        CloudProvider cp = providers.get(providerName);
        if (cp == null) {
            throw new Exception("Inexistent Cloud Provider " + providerName);
        }
        cp.addCloudImage(cid);
    }

    public static void addInstanceTypeToProvider(String providerName, CloudMethodResourceDescription rd) throws Exception {
        CloudProvider cp = providers.get(providerName);
        if (cp == null) {
            throw new Exception("Inexistent Cloud Provider " + providerName);
        }
        cp.addInstanceType(rd);
    }

    public static void newCoreElementsDetected(LinkedList<Integer> newCores) {
        pendingCoreCount = new int[CoreManager.getCoreCount()];
        for (ResourceCreationRequest rcr : pendingRequests) {
            int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
            int coreId = 0;
            while (coreId < reqCounts.length) {
                int coreSlots = 0;
                for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                    coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
                }
                int n = coreId++;
                pendingCoreCount[n] = pendingCoreCount[n] + coreSlots;
            }
        }
        for (CloudProvider cp : providers.values()) {
            cp.newCoreElementsDetected(newCores);
        }
    }

    public static LinkedList<ResourceCreationRequest> getPendingRequests() {
        return pendingRequests;
    }

    public static int[] getPendingCoreCounts() {
        return pendingCoreCount;
    }

    public static ResourceCreationRequest askForResources(MethodResourceDescription requirements, boolean contained) {
        return CloudManager.askForResources(1, requirements, contained);
    }

    public static ResourceCreationRequest askForResources(Integer amount, MethodResourceDescription requirements, boolean contained) {
        int coreCount = CoreManager.getCoreCount();
        CloudProvider bestProvider = null;
        CloudMethodResourceDescription bestConstraints = null;
        Float bestValue = Float.valueOf(Float.MAX_VALUE);
        for (CloudProvider cp : providers.values()) {
            CloudMethodResourceDescription rc = cp.getBestIncrease(amount, requirements, contained);
            if (rc == null || !(rc.getValue().floatValue() < bestValue.floatValue())) continue;
            bestProvider = cp;
            bestConstraints = rc;
            bestValue = rc.getValue();
        }
        if (bestConstraints == null) {
            return null;
        }
        Object simultaneousCounts = bestProvider.getSimultaneousImpls(bestConstraints.getType());
        if (simultaneousCounts == null) {
            simultaneousCounts = new int[coreCount][];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                Implementation[] impls = CoreManager.getCoreImplementations((int)coreId);
                simultaneousCounts[coreId] = new int[impls.length];
                for (int implId = 0; implId < impls.length; ++implId) {
                    MethodResourceDescription description;
                    if (impls[implId].getType() != Implementation.Type.METHOD || (description = (MethodResourceDescription)impls[implId].getRequirements()) == null) continue;
                    Integer into = bestConstraints.canHostSimultaneously(description);
                    simultaneousCounts[coreId][implId] = into;
                }
            }
        }
        runtimeLogger.debug((Object)"Asking for resource creation");
        ResourceCreationRequest rcr = new ResourceCreationRequest(bestConstraints, (int[][])simultaneousCounts, bestProvider.getName());
        try {
            if (bestProvider.turnON(rcr)) {
                pendingRequests.add(rcr);
                int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
                int coreId = 0;
                while (coreId < reqCounts.length) {
                    int coreSlots = 0;
                    for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                        coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
                    }
                    int n = coreId++;
                    pendingCoreCount[n] = pendingCoreCount[n] + coreSlots;
                }
                return rcr;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void confirmedRequest(ResourceCreationRequest rcr, CloudMethodWorker r) {
        pendingRequests.remove(rcr);
        int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < reqCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
            }
            int n = coreId++;
            pendingCoreCount[n] = pendingCoreCount[n] - coreSlots;
        }
        String provider = rcr.getProvider();
        CloudProvider cp = providers.get(provider);
        String vmName = r.getName();
        VM2Provider.put(vmName, cp);
        cp.createdVM(vmName, (CloudMethodResourceDescription)((Object)r.getDescription()));
    }

    public static void refusedRequest(ResourceCreationRequest rcr) {
        pendingRequests.remove(rcr);
        int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < reqCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
            }
            int n = coreId++;
            pendingCoreCount[n] = pendingCoreCount[n] - coreSlots;
        }
        CloudProvider cp = providers.get(rcr.getProvider());
        cp.refusedWorker(rcr.getRequested());
    }

    public static Object[] getBestDestruction(Collection<CloudMethodWorker> resourceSet, float[] destroyRecommendations) {
        float[] bestRecord = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MIN_VALUE};
        CloudMethodWorker bestResource = null;
        CloudProvider bestCP = null;
        String bestType = null;
        CloudMethodResourceDescription bestRD = null;
        for (CloudMethodWorker res : resourceSet) {
            CloudProvider cp = VM2Provider.get(res.getName());
            if (cp == null) continue;
            HashMap<String, Object[]> typeToPoints = cp.getPossibleReductions(res, destroyRecommendations);
            for (Map.Entry<String, Object[]> destruction : typeToPoints.entrySet()) {
                String typeName = destruction.getKey();
                Object[] description = destruction.getValue();
                float[] values = (float[])description[0];
                CloudMethodResourceDescription rd = (CloudMethodResourceDescription)((Object)description[1]);
                if (bestRecord[0] == values[0]) {
                    if (bestRecord[1] == values[1]) {
                        if (!(bestRecord[2] < values[2])) continue;
                        bestRecord = values;
                        bestResource = res;
                        bestType = typeName;
                        bestCP = cp;
                        bestRD = rd;
                        continue;
                    }
                    if (!(bestRecord[1] > values[1])) continue;
                    bestRecord = values;
                    bestResource = res;
                    bestType = typeName;
                    bestCP = cp;
                    bestRD = rd;
                    continue;
                }
                if (!(bestRecord[0] > values[0])) continue;
                bestRecord = values;
                bestResource = res;
                bestType = typeName;
                bestCP = cp;
                bestRD = rd;
            }
        }
        if (bestResource != null) {
            Object[] ret = new Object[]{bestResource, bestRecord, bestCP.getSimultaneousImpls(bestType), bestRD};
            return ret;
        }
        return null;
    }

    public static void destroyResources(CloudMethodWorker res, CloudMethodResourceDescription reduction) {
        runtimeLogger.debug((Object)"Destroying resources for reduction");
        CloudProvider cp = VM2Provider.get(res.getName());
        cp.turnOff(res, reduction);
    }

    public static void terminateALL() throws ConnectorException {
        runtimeLogger.debug((Object)"Terminate ALL resources");
        for (Map.Entry<String, CloudProvider> vm : providers.entrySet()) {
            CloudProvider cp = vm.getValue();
            cp.terminateAll();
        }
        VM2Provider.clear();
    }

    public static float currentCostPerHour() {
        float total = 0.0f;
        for (CloudProvider cp : providers.values()) {
            total += cp.getCurrentCostPerHour();
        }
        return total;
    }

    public static void stopReached() {
        for (CloudProvider cp : providers.values()) {
            cp.stopReached();
        }
    }

    public static float getTotalCost() {
        float total = 0.0f;
        for (CloudProvider cp : providers.values()) {
            total += cp.getTotalCost();
        }
        return total;
    }

    public static long getNextCreationTime() throws Exception {
        long total = 0L;
        for (CloudProvider cp : providers.values()) {
            total = Math.max(total, cp.getNextCreationTime());
        }
        return total;
    }

    public static long getTimeSlot() throws Exception {
        long total = Long.MAX_VALUE;
        for (CloudProvider cp : providers.values()) {
            total = Math.min(total, cp.getTimeSlot());
        }
        return total;
    }

    public static int getCurrentVMCount() {
        int total = 0;
        for (CloudProvider cp : providers.values()) {
            total += cp.getCurrentVMCount();
        }
        return total;
    }

    public static String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("CLOUD = [").append("\n");
        sb.append(prefix).append("\t").append("CURRENT_STATE = [").append("\n");
        for (CloudProvider cp : providers.values()) {
            sb.append(cp.getCurrentState(prefix + "\t" + "\t"));
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("PENDING_REQUESTS = [").append("\n");
        for (ResourceCreationRequest rcr : pendingRequests) {
            sb.append(prefix).append("\t").append("\t").append("REQUEST = ").append(rcr.getRequested().getType()).append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]");
        return sb.toString();
    }

    public static CloudProvider getProvider(String name) {
        if (providers.containsKey(name)) {
            return providers.get(name);
        }
        return null;
    }

    static {
        pendingRequests = new LinkedList();
        pendingCoreCount = new int[CoreManager.getCoreCount()];
        resourcesLogger = Logger.getLogger((String)"integratedtoolkit.Resources");
        runtimeLogger = Logger.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    }
}

