/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.comm;

import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.data.operation.Delete;
import integratedtoolkit.util.RequestDispatcher;
import integratedtoolkit.util.RequestQueue;
import org.apache.log4j.Logger;

public class Dispatcher
extends RequestDispatcher<DataOperation> {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    public static final boolean debug = logger.isDebugEnabled();

    public Dispatcher(RequestQueue<DataOperation> queue) {
        super(queue);
    }

    @Override
    public void processRequests() {
        DataOperation fOp;
        while ((fOp = (DataOperation)this.queue.dequeue()) != null) {
            if (fOp instanceof Copy.ImmediateCopy) {
                Copy.ImmediateCopy c = (Copy.ImmediateCopy)fOp;
                c.perform();
                continue;
            }
            if (fOp instanceof Copy.DeferredCopy) continue;
            Delete d = (Delete)fOp;
            Dispatcher.performOperation(d);
        }
    }

    public static void performOperation(Delete d) {
        logger.debug("THREAD " + Thread.currentThread().getName() + " Delete " + d.getFile());
        try {
            d.getFile().delete();
        }
        catch (Exception e) {
            d.end(DataOperation.OpEndState.OP_FAILED, e);
            return;
        }
        d.end(DataOperation.OpEndState.OP_OK);
    }
}

