/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.util.CoreManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Worker<T extends ResourceDescription>
extends Resource {
    protected final T description;
    protected int maxTaskCount;
    protected int taskCount;
    private LinkedList<Integer> executableCores;
    private LinkedList<Implementation<?>>[] executableImpls;
    private int[][] implSimultaneousTasks;
    private int[] coreSimultaneousTasks;
    private int[] idealSimultaneousTasks;
    private final AtomicInteger preschedSlots;
    private final LinkedList<Job<?>> pendingPresched = new LinkedList();

    public Worker(String name, T description, COMPSsNode worker, Integer maxTaskCount) {
        super(worker);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.maxTaskCount = maxTaskCount;
        this.preschedSlots = new AtomicInteger(maxTaskCount);
        this.taskCount = 0;
        this.executableCores = new LinkedList();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getCoreImplementations(coreId).length];
        }
        this.description = description;
    }

    public Worker(String name, T description, TreeMap<String, AdaptorDescription> adaptorsDesc, HashMap<String, String> properties, Integer maxTaskCount) throws Exception {
        super(name, properties, adaptorsDesc);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.maxTaskCount = maxTaskCount;
        this.preschedSlots = new AtomicInteger(maxTaskCount);
        this.taskCount = 0;
        this.executableCores = new LinkedList();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getCoreImplementations(coreId).length];
        }
        this.description = description;
    }

    public T getDescription() {
        return this.description;
    }

    public void setMaxTaskCount(int count) {
        this.maxTaskCount = count;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public int getMaxTaskCount() {
        return this.maxTaskCount;
    }

    public void updatedCoreElements(LinkedList<Integer> updatedCoreIds) {
        int coreCount = CoreManager.getCoreCount();
        boolean[] coresToUpdate = new boolean[coreCount];
        Iterator i$ = updatedCoreIds.iterator();
        while (i$.hasNext()) {
            int coreId = (Integer)i$.next();
            coresToUpdate[coreId] = true;
        }
        boolean[] wasExecutable = new boolean[coreCount];
        Iterator i$2 = this.executableCores.iterator();
        while (i$2.hasNext()) {
            int coreId = (Integer)i$2.next();
            wasExecutable[coreId] = true;
        }
        this.executableCores.clear();
        LinkedList[] executableImpls = new LinkedList[coreCount];
        int[][] implSimultaneousTasks = new int[coreCount][];
        int[] coreSimultaneousTasks = new int[coreCount];
        int[] idealSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (!coresToUpdate[coreId]) {
                executableImpls[coreId] = this.executableImpls[coreId];
                implSimultaneousTasks[coreId] = this.implSimultaneousTasks[coreId];
                coreSimultaneousTasks[coreId] = this.coreSimultaneousTasks[coreId];
                idealSimultaneousTasks[coreId] = this.idealSimultaneousTasks[coreId];
                if (!wasExecutable[coreId]) continue;
                this.executableCores.add(coreId);
                continue;
            }
            boolean executableCore = false;
            Implementation<?>[] impls = CoreManager.getCoreImplementations(coreId);
            implSimultaneousTasks[coreId] = new int[impls.length];
            executableImpls[coreId] = new LinkedList();
            for (Implementation<?> impl : impls) {
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                idealSimultaneousTasks[coreId] = Math.max(idealSimultaneousTasks[coreId], simultaneousCapacity);
                implSimultaneousTasks[coreId][impl.getImplementationId()] = Math.min(this.maxTaskCount, simultaneousCapacity);
                if (implSimultaneousTasks[coreId][impl.getImplementationId()] <= 0) continue;
                executableImpls[coreId].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.executableCores.add(coreId);
        }
        this.executableImpls = executableImpls;
        this.implSimultaneousTasks = implSimultaneousTasks;
        this.coreSimultaneousTasks = coreSimultaneousTasks;
        this.idealSimultaneousTasks = idealSimultaneousTasks;
    }

    public void updatedFeatures() {
        int coreCount = CoreManager.getCoreCount();
        this.executableCores.clear();
        this.executableImpls = new LinkedList[coreCount];
        this.implSimultaneousTasks = new int[coreCount][];
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            boolean executableCore = false;
            Implementation<?>[] impls = CoreManager.getCoreImplementations(coreId);
            this.implSimultaneousTasks[coreId] = new int[impls.length];
            this.executableImpls[coreId] = new LinkedList();
            for (Implementation<?> impl : impls) {
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                this.idealSimultaneousTasks[coreId] = Math.max(this.idealSimultaneousTasks[coreId], simultaneousCapacity);
                this.implSimultaneousTasks[coreId][impl.getImplementationId()] = Math.min(this.maxTaskCount, simultaneousCapacity);
                if (this.implSimultaneousTasks[coreId][impl.getImplementationId()] <= 0) continue;
                this.executableImpls[coreId].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.coreSimultaneousTasks[coreId] = Math.min(this.maxTaskCount, this.idealSimultaneousTasks[coreId]);
            this.executableCores.add(coreId);
        }
    }

    public LinkedList<Integer> getExecutableCores() {
        return this.executableCores;
    }

    public LinkedList<Implementation<?>>[] getExecutableImpls() {
        return this.executableImpls;
    }

    public LinkedList<Implementation<?>> getExecutableImpls(int coreId) {
        return this.executableImpls[coreId];
    }

    public int[] getIdealSimultaneousTasks() {
        return this.idealSimultaneousTasks;
    }

    public int[] getSimultaneousTasks() {
        return this.coreSimultaneousTasks;
    }

    public Integer simultaneousCapacity(Implementation<?> impl) {
        return Math.min(this.fitCount(impl), this.maxTaskCount);
    }

    public String getResourceLinks(String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("NAME = ").append(this.getName()).append("\n");
        sb.append(prefix).append("EXEC_CORES = ").append(this.executableCores).append("\n");
        sb.append(prefix).append("CORE_SIMTASKS = [").append("\n");
        for (i = 0; i < this.coreSimultaneousTasks.length; ++i) {
            sb.append(prefix).append("\t").append("CORE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
            sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.coreSimultaneousTasks[i]).append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("IMPL_SIMTASKS = [").append("\n");
        for (i = 0; i < this.implSimultaneousTasks.length; ++i) {
            for (int j = 0; j < this.implSimultaneousTasks[i].length; ++j) {
                sb.append(prefix).append("\t").append("IMPLEMENTATION = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.implSimultaneousTasks[i][j]).append("\n");
                sb.append(prefix).append("\t").append("]").append("\n");
            }
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    public LinkedList<Implementation<?>>[] getRunnableImplementations() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] runnable = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            runnable[coreId] = this.getRunnableImplementations(coreId);
        }
        return runnable;
    }

    public LinkedList<Implementation<?>> getRunnableImplementations(int coreId) {
        LinkedList runnable = new LinkedList();
        for (Implementation implementation : this.executableImpls[coreId]) {
            if (!this.canRunNow(implementation.getRequirements())) continue;
            runnable.add(implementation);
        }
        return runnable;
    }

    public boolean canRun(int coreId) {
        return this.idealSimultaneousTasks[coreId] > 0;
    }

    public LinkedList<Implementation<?>> canRunNow(LinkedList<Implementation<?>> candidates) {
        LinkedList runnable = new LinkedList();
        for (Implementation implementation : candidates) {
            if (!this.canRunNow(implementation.getRequirements())) continue;
            runnable.add(implementation);
        }
        return runnable;
    }

    public boolean canRunNow(T consumption) {
        return this.taskCount < this.maxTaskCount && this.hasAvailable(consumption);
    }

    public void endTask(T consumption) {
        logger.debug("End task received. Releasing resource." + consumption.getClass().toString());
        --this.taskCount;
        this.releaseResource(consumption);
    }

    public boolean runTask(T consumption) {
        if (this.reserveResource(consumption)) {
            ++this.taskCount;
            return true;
        }
        return false;
    }

    public boolean tryAcquirePreschSlot() {
        int freeSlots = this.preschedSlots.decrementAndGet();
        if (freeSlots < 0) {
            this.preschedSlots.incrementAndGet();
            return false;
        }
        return true;
    }

    public void releasePreschSlot() {
        this.preschedSlots.incrementAndGet();
    }

    public void addPendingJob(Job<?> j) {
        this.pendingPresched.add(j);
    }

    public Job<?> getPendingJob() {
        if (!this.pendingPresched.isEmpty()) {
            return this.pendingPresched.removeFirst();
        }
        return this.pendingPresched.removeFirst();
    }

    public abstract String getMonitoringData(String var1);

    public abstract boolean canRun(Implementation<?> var1);

    public abstract Integer fitCount(Implementation<?> var1);

    public abstract boolean hasAvailable(T var1);

    public abstract boolean reserveResource(T var1);

    public abstract void releaseResource(T var1);

    public void announceCreation() throws Exception {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceCreation();
    }

    public void announceDestruction() throws Exception {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceDestruction();
    }
}

