/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.MethodWorker;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ResourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class WorkerStarter
implements Runnable {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    public static final boolean debug = logger.isDebugEnabled();
    private static int[] onStartCoreCounts = new int[CoreManager.getCoreCount()];
    private final String name;
    private final MethodResourceDescription rd;
    private final HashMap<String, String> properties;
    private final int taskCount;
    private final HashMap<String, String> disks;
    private final int[] expectedCoreCount;
    private final TreeMap<String, AdaptorDescription> adaptorsDescription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerStarter(String name, MethodResourceDescription rd, HashMap<String, String> properties, HashMap<String, String> disks, TreeMap<String, AdaptorDescription> adaptorsDesc) {
        this.name = name;
        this.rd = rd;
        this.properties = properties;
        this.adaptorsDescription = adaptorsDesc;
        String taskCountStr = properties.get("LimitOfTasks");
        int taskCount = 0;
        if (taskCountStr != null) {
            taskCount = Integer.parseInt(taskCountStr);
        }
        if (taskCount <= 0) {
            taskCount = rd.getProcessorCoreCount();
        }
        this.taskCount = taskCount;
        properties.put("LimitOfTasks", "" + taskCount);
        this.disks = disks;
        this.expectedCoreCount = this.computeExpectedCoreCount(taskCount);
        int[] nArray = onStartCoreCounts;
        synchronized (onStartCoreCounts) {
            for (int coreId = 0; coreId < this.expectedCoreCount.length; ++coreId) {
                int n = coreId;
                onStartCoreCounts[n] = onStartCoreCounts[n] + this.expectedCoreCount[coreId];
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MethodWorker newResource;
        Thread.currentThread().setName(this.name + " starter");
        try {
            newResource = new MethodWorker(this.name, this.rd, this.adaptorsDescription, this.properties, (Integer)this.taskCount);
        }
        catch (Exception e) {
            logger.error("Error starting resource", e);
            return;
        }
        for (Map.Entry<String, String> disk : this.disks.entrySet()) {
            newResource.addSharedDisk(disk.getKey(), disk.getValue());
        }
        int[] nArray = onStartCoreCounts;
        synchronized (onStartCoreCounts) {
            for (int coreId = 0; coreId < this.expectedCoreCount.length; ++coreId) {
                int n = coreId;
                onStartCoreCounts[n] = onStartCoreCounts[n] - this.expectedCoreCount[coreId];
            }
            ResourceManager.addStaticWorker(newResource);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getExpectedCoreCount() {
        int[] nArray = onStartCoreCounts;
        synchronized (onStartCoreCounts) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return onStartCoreCounts;
        }
    }

    public int[] computeExpectedCoreCount(int taskCount) {
        int coreCount = CoreManager.getCoreCount();
        int[] coreSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            Implementation<?>[] impls = CoreManager.getCoreImplementations(coreId);
            int ideal = 0;
            for (Implementation<?> impl : impls) {
                if (this.rd.canHost(impl)) {
                    ideal = Math.max(this.rd.canHostSimultaneously((MethodResourceDescription)impl.getRequirements()), ideal);
                }
                coreSimultaneousTasks[coreId] = Math.min(taskCount, ideal);
            }
        }
        return coreSimultaneousTasks;
    }
}

