/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.AdaptorTestResult;
import benchmarks.AdaptorTestResultEntry;
import java.io.File;
import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;

public class FileAdaptorTest {
    public static void main(String[] args) {
        FileAdaptorTest a = new FileAdaptorTest();
        a.test(args[0], args[1]).print();
        GAT.end();
    }

    public AdaptorTestResult test(String adaptor, String host) {
        this.run(host, "adaptor-test-init.sh");
        AdaptorTestResult adaptorTestResult = new AdaptorTestResult(adaptor, host);
        GATContext gatContext = new GATContext();
        PasswordSecurityContext password = new PasswordSecurityContext("username", "TeMpPaSsWoRd");
        password.addNote("adaptors", "ftp");
        gatContext.addSecurityContext((SecurityContext)password);
        Preferences preferences = new Preferences();
        preferences.put("file.adaptor.name", (Object)(adaptor + ",local"));
        adaptorTestResult.put("exists: absolute existing file", this.existTest(gatContext, preferences, host, "/tmp/JavaGAT-test-exists-file", 0, true));
        adaptorTestResult.put("exists: absolute existing dir", this.existTest(gatContext, preferences, host, "/tmp/JavaGAT-test-exists-dir", 0, true));
        adaptorTestResult.put("exists: absolute non-existing file", this.existTest(gatContext, preferences, host, "/tmp/JavaGAT-test-exists-fake", 0, false));
        adaptorTestResult.put("exists: relative existing file", this.existTest(gatContext, preferences, host, "JavaGAT-test-exists-file", 1, true));
        adaptorTestResult.put("exists: relative existing dir", this.existTest(gatContext, preferences, host, "JavaGAT-test-exists-dir", 1, true));
        adaptorTestResult.put("exists: relative non-existing file", this.existTest(gatContext, preferences, host, "JavaGAT-test-exists-fake", 1, false));
        adaptorTestResult.put("mkdir: absolute non-existing dir", this.mkdirTest(gatContext, preferences, host, "/tmp/JavaGAT-test-mkdir-dir", 0, true));
        adaptorTestResult.put("mkdir: absolute existing dir", this.mkdirTest(gatContext, preferences, host, "/tmp/JavaGAT-test-mkdir-dir", 0, false));
        adaptorTestResult.put("mkdir: relative non-existing dir", this.mkdirTest(gatContext, preferences, host, "JavaGAT-test-mkdir-dir", 1, true));
        adaptorTestResult.put("mkdir: relative existing dir", this.mkdirTest(gatContext, preferences, host, "JavaGAT-test-mkdir-dir", 1, false));
        adaptorTestResult.put("mkdirs: absolute non-existing dir", this.mkdirsTest(gatContext, preferences, host, "/tmp/JavaGAT-test-mkdirs/1/2/3", 0, true));
        adaptorTestResult.put("mkdirs: absolute existing dir", this.mkdirsTest(gatContext, preferences, host, "/tmp/JavaGAT-test-mkdirs/1/2/3", 0, false));
        adaptorTestResult.put("mkdirs: relative non-existing dir", this.mkdirsTest(gatContext, preferences, host, "JavaGAT-test-mkdirs/1/2/3", 0, true));
        adaptorTestResult.put("mkdirs: relative existing dir", this.mkdirsTest(gatContext, preferences, host, "JavaGAT-test-mkdirs/1/2/3", 0, false));
        adaptorTestResult.put("delete: absolute existing file", this.deleteTest(gatContext, preferences, host, "/tmp/JavaGAT-test-delete-file", 0, true));
        adaptorTestResult.put("delete: absolute non-existing file", this.deleteTest(gatContext, preferences, host, "/tmp/JavaGAT-test-delete-file", 0, false));
        adaptorTestResult.put("delete: absolute existing dir", this.deleteTest(gatContext, preferences, host, "/tmp/JavaGAT-test-delete-dir/", 0, true));
        adaptorTestResult.put("delete: absolute non-existing dir", this.deleteTest(gatContext, preferences, host, "/tmp/JavaGAT-test-delete-fake", 0, false));
        adaptorTestResult.put("delete: relative existing file", this.deleteTest(gatContext, preferences, host, "JavaGAT-test-delete-file", 0, true));
        adaptorTestResult.put("delete: relative non-existing file", this.deleteTest(gatContext, preferences, host, "JavaGAT-test-delete-file", 0, false));
        adaptorTestResult.put("delete: relative existing dir", this.deleteTest(gatContext, preferences, host, "JavaGAT-test-delete-dir", 1, true));
        adaptorTestResult.put("delete: relative non-existing dir", this.deleteTest(gatContext, preferences, host, "JavaGAT-test-delete-dir", 1, false));
        adaptorTestResult.put("isFile: existing dir", this.isFileTest(gatContext, preferences, host, "JavaGAT-test-filedir-dir", 0, false));
        adaptorTestResult.put("isFile: existing file", this.isFileTest(gatContext, preferences, host, "JavaGAT-test-filedir-file", 0, true));
        adaptorTestResult.put("isFile: non-existing file", this.isFileTest(gatContext, preferences, host, "JavaGAT-test-filedir-fake", 0, false));
        adaptorTestResult.put("isDirectory: existing dir", this.isDirectoryTest(gatContext, preferences, host, "JavaGAT-test-filedir-dir", 0, true));
        adaptorTestResult.put("isDirectory: existing file", this.isDirectoryTest(gatContext, preferences, host, "JavaGAT-test-filedir-file", 0, false));
        adaptorTestResult.put("isDirectory: non-existing file", this.isDirectoryTest(gatContext, preferences, host, "JavaGAT-test-filedir-fake", 0, false));
        adaptorTestResult.put("canRead: readable file", this.canReadTest(gatContext, preferences, host, "JavaGAT-test-mode-readable", 0, true));
        adaptorTestResult.put("canRead: non-readable file", this.canReadTest(gatContext, preferences, host, "JavaGAT-test-mode-unreadable", 0, false));
        adaptorTestResult.put("canRead: non-existent file", this.canReadTest(gatContext, preferences, host, "JavaGAT-test-mode-does-not-exist", 0, false));
        adaptorTestResult.put("canWrite: writable file", this.canWriteTest(gatContext, preferences, host, "JavaGAT-test-mode-writable", 0, true));
        adaptorTestResult.put("canWrite: non-writable file", this.canWriteTest(gatContext, preferences, host, "JavaGAT-test-mode-unwritable", 0, false));
        adaptorTestResult.put("canWrite: non-existent file", this.canWriteTest(gatContext, preferences, host, "JavaGAT-test-mode-does-not-exist", 0, false));
        adaptorTestResult.put("length, existing file:", this.lengthTest(gatContext, preferences, host, "JavaGAT-test-length", 1, 6L));
        adaptorTestResult.put("length, non-existent file:", this.lengthTest(gatContext, preferences, host, "JavaGAT-test-length-nonexistent", 1, 0L));
        adaptorTestResult.put("list:", this.listTest(gatContext, preferences, host, "JavaGAT-test-list", 2, "file1", "file2", "dir1"));
        adaptorTestResult.put("lastModified, existent file:", this.lastModifiedTest(gatContext, preferences, host, "JavaGAT-test-last-modified", 0, 458258400000L));
        adaptorTestResult.put("lastModified, non-existent file:", this.lastModifiedTest(gatContext, preferences, host, "JavaGAT-test-last-modified-nonexist", 0, 0L));
        adaptorTestResult.put("createNewFile: non-existent file", this.createNewFileTest(gatContext, preferences, host, "JavaGAT-test-new-file", 1, true));
        adaptorTestResult.put("createNewFile: existent file", this.createNewFileTest(gatContext, preferences, host, "JavaGAT-test-new-file", 1, false));
        adaptorTestResult.put("copy: small relative file", this.copyFileTest(gatContext, preferences, host, "JavaGAT-test-copy-small", 1, true));
        adaptorTestResult.put("copy: large relative file", this.copyFileTest(gatContext, preferences, host, "JavaGAT-test-copy-large", 1, true));
        adaptorTestResult.put("copy: small absolute file", this.copyFileTest(gatContext, preferences, host, "/tmp/JavaGAT-test-copy-small", 1, true));
        adaptorTestResult.put("copy: large absolute file", this.copyFileTest(gatContext, preferences, host, "/tmp/JavaGAT-test-copy-large", 1, true));
        this.run(host, "adaptor-test-clean.sh");
        return adaptorTestResult;
    }

    private void run(String host, String script) {
        Preferences preferences = new Preferences();
        preferences.put("resourcebroker.adaptor.name", (Object)"commandlinessh,sshtrilead,local");
        preferences.put("file.adaptor.name", (Object)"commandlinessh,sshtrilead,local");
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/bash");
        sd.setArguments(new String[]{script});
        try {
            sd.addPreStagedFile(GAT.createFile((Preferences)preferences, (String)("tests" + File.separator + "src" + File.separator + "benchmarks" + File.separator + script)));
        }
        catch (GATObjectCreationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        ResourceBroker broker = null;
        try {
            broker = GAT.createResourceBroker((Preferences)preferences, (URI)new URI("any://" + host));
        }
        catch (GATObjectCreationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Job job = null;
        try {
            job = broker.submitJob((AbstractJobDescription)new JobDescription(sd));
        }
        catch (GATInvocationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        while (job.getState() != Job.JobState.STOPPED && job.getState() != Job.JobState.SUBMISSION_ERROR) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
    }

    private AdaptorTestResultEntry existTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean exists;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            exists = file.exists();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(exists == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry mkdirTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean mkdir;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            mkdir = file.mkdir();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(mkdir == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry mkdirsTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean mkdirs;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            mkdirs = file.mkdirs();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(mkdirs == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry deleteTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean delete;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            delete = file.delete();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(delete == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry isFileTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        boolean isFile = false;
        long start = System.currentTimeMillis();
        try {
            isFile = file.isFile();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(isFile == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry isDirectoryTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        boolean isDir = false;
        long start = System.currentTimeMillis();
        try {
            isDir = file.isDirectory();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(isDir == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry canReadTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean readable;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            readable = file.canRead();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(readable == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry canWriteTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean writable;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            writable = file.canWrite();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(writable == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry lengthTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, long correctValue) {
        long length;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            length = file.length();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(length == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry listTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, String ... correctValue) {
        String[] list;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            list = file.list();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(FileAdaptorTest.isCorrect(list, correctValue), stop - start, null);
    }

    private static boolean isCorrect(String[] list, String[] correctValue) {
        if (list == null) {
            return correctValue == null;
        }
        if (correctValue == null) {
            return false;
        }
        if (correctValue.length != list.length) {
            return false;
        }
        for (String entry : list) {
            boolean exists = false;
            for (String correctEntry : correctValue) {
                if (!entry.equals(correctEntry)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }

    private AdaptorTestResultEntry lastModifiedTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, long correctValue) {
        long time;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            time = file.lastModified();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(time == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry createNewFileTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        boolean created;
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            created = file.createNewFile();
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(created == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry copyFileTest(GATContext gatContext, Preferences preferences, String host, String filename, int tabs, boolean correctValue) {
        FileInterface file = null;
        try {
            file = GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/" + filename)).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            file.copy(new URI("any:///" + filename + ".copy"));
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        boolean exists = new File(filename + ".copy").exists();
        if (exists) {
            new File(filename + ".copy").delete();
        }
        return new AdaptorTestResultEntry(exists == correctValue, stop - start, null);
    }
}

